/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.builder;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r5.model.Bundle;
import org.opencds.cqf.fhir.utility.builder.ResourceBuilder;

public class BundleBuilder<T extends IBaseBundle>
extends ResourceBuilder<BundleBuilder<T>, T> {
    private String myType;
    private Date myTimestamp = new Date();

    public BundleBuilder(Class<T> theResourceClass) {
        super(theResourceClass);
    }

    public BundleBuilder(Class<T> theResourceClass, String theId) {
        super(theResourceClass, theId);
    }

    public BundleBuilder(Class<T> theResourceClass, String theId, String theType) {
        this(theResourceClass, theId);
        Preconditions.checkNotNull((Object)theType);
        this.myType = theType;
    }

    public BundleBuilder<T> withType(String theType) {
        Preconditions.checkNotNull((Object)theType);
        this.myType = theType;
        return this;
    }

    public BundleBuilder<T> withTimestamp(Date theTimestamp) {
        this.myTimestamp = theTimestamp;
        return this;
    }

    @Override
    public T build() {
        Preconditions.checkNotNull((Object)this.myType);
        return (T)((IBaseBundle)super.build());
    }

    @Override
    protected void initializeDstu3(T theResource) {
        super.initializeDstu3(theResource);
        Bundle bundle = (Bundle)theResource;
        bundle.setType(Bundle.BundleType.valueOf((String)this.myType));
        bundle.setIdentifier(new Identifier().setSystem((String)this.getIdentifier().getKey()).setValue((String)this.getIdentifier().getValue()));
    }

    @Override
    protected void initializeR4(T theResource) {
        super.initializeR4(theResource);
        org.hl7.fhir.r4.model.Bundle bundle = (org.hl7.fhir.r4.model.Bundle)theResource;
        bundle.setType(Bundle.BundleType.valueOf((String)this.myType));
        bundle.setIdentifier(new org.hl7.fhir.r4.model.Identifier().setSystem((String)this.getIdentifier().getKey()).setValue((String)this.getIdentifier().getValue()));
        bundle.setTimestamp(this.myTimestamp);
    }

    @Override
    protected void initializeR5(T theResource) {
        super.initializeR5(theResource);
        org.hl7.fhir.r5.model.Bundle bundle = (org.hl7.fhir.r5.model.Bundle)theResource;
        bundle.setType(Bundle.BundleType.valueOf((String)this.myType));
        bundle.setIdentifier(new org.hl7.fhir.r5.model.Identifier().setSystem((String)this.getIdentifier().getKey()).setValue((String)this.getIdentifier().getValue()));
        bundle.setTimestamp(this.myTimestamp);
    }
}

