/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.builder;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.fhir.utility.Resources;

public abstract class ResourceBuilder<SELF, T extends IBaseResource> {
    public static final String DEFAULT_IDENTIFIER_SYSTEM = "urn:ietf:rfc:3986";
    public static final String DEFAULT_IDENTIFIER_VALUE_PREFIX = "urn:uuid:";
    private final Class<T> myResourceClass;
    private List<String> myProfile;
    private String myId = UUID.randomUUID().toString();
    private Pair<String, String> myIdentifier = new ImmutablePair((Object)"urn:ietf:rfc:3986", (Object)("urn:uuid:" + UUID.randomUUID().toString()));

    protected ResourceBuilder(Class<T> theResourceClass) {
        Preconditions.checkNotNull(theResourceClass);
        this.myResourceClass = theResourceClass;
    }

    protected ResourceBuilder(Class<T> theResourceClass, String theId) {
        this(theResourceClass);
        Preconditions.checkNotNull((Object)theId);
        this.myId = theId;
    }

    protected SELF self() {
        ResourceBuilder resourceBuilder = this;
        return (SELF)resourceBuilder;
    }

    public static String ensurePatientReference(String thePatientId) {
        if (Strings.isNullOrEmpty((String)thePatientId) || thePatientId.startsWith("Patient/")) {
            return thePatientId;
        }
        return "Patient/" + thePatientId;
    }

    public static String ensureOrganizationReference(String theOrganizationId) {
        if (Strings.isNullOrEmpty((String)theOrganizationId) || theOrganizationId.startsWith("Organization/")) {
            return theOrganizationId;
        }
        return "Organization/" + theOrganizationId;
    }

    private void addProfile(String profile) {
        if (this.myProfile == null) {
            this.myProfile = new ArrayList<String>();
        }
        this.myProfile.add(profile);
    }

    protected List<String> getProfiles() {
        if (this.myProfile == null) {
            return Collections.emptyList();
        }
        return this.myProfile;
    }

    protected String getId() {
        return this.myId;
    }

    protected Pair<String, String> getIdentifier() {
        return this.myIdentifier;
    }

    public SELF withId(String theId) {
        Preconditions.checkNotNull((Object)theId);
        this.myId = theId;
        return this.self();
    }

    public SELF withProfile(String theProfile) {
        Preconditions.checkNotNull((Object)theProfile);
        this.addProfile(theProfile);
        return this.self();
    }

    public SELF withIdentifier(Pair<String, String> theIdentifier) {
        this.myIdentifier = theIdentifier;
        return this.self();
    }

    public T build() {
        T resource = Resources.newResource(this.myResourceClass, this.myId);
        switch (resource.getStructureFhirVersionEnum()) {
            case DSTU3: {
                this.initializeDstu3(resource);
                break;
            }
            case R4: {
                this.initializeR4(resource);
                break;
            }
            case R5: {
                this.initializeR5(resource);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("ResourceBuilder.initializeResource does not support FHIR version %s", resource.getStructureFhirVersionEnum().getFhirVersionString()));
            }
        }
        return resource;
    }

    private void addProfiles(T theResource) {
        this.getProfiles().forEach(profile -> theResource.getMeta().addProfile(profile));
    }

    protected void initializeDstu3(T theResource) {
        this.addProfiles(theResource);
    }

    protected void initializeR4(T theResource) {
        this.addProfiles(theResource);
    }

    protected void initializeR5(T theResource) {
        this.addProfiles(theResource);
    }
}

