/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.monad;

import java.util.function.Function;
import org.opencds.cqf.fhir.utility.monad.Either;
import org.opencds.cqf.fhir.utility.monad.Tries;

public class Try<T>
extends Either<Exception, T> {
    Try(Exception left, T right) {
        super(left, right);
    }

    public boolean hasException() {
        return this.isLeft();
    }

    public boolean hasResult() {
        return this.isRight();
    }

    public Exception exception() {
        return (Exception)this.left();
    }

    public <X> Try<X> map(Function<? super T, ? extends X> map) {
        if (this.hasException()) {
            return this;
        }
        try {
            return Tries.of(map.apply(this.right()));
        }
        catch (Exception e) {
            return Tries.ofException(e);
        }
    }

    public <X> Try<X> flatMap(Function<? super T, ? extends Either<Exception, ? extends X>> flatMapRight) {
        if (this.hasException()) {
            return this;
        }
        try {
            return flatMapRight.apply(this.right()).fold(Tries::ofException, Tries::of);
        }
        catch (Exception e) {
            return Tries.ofException(e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Try) {
            Try other = (Try)obj;
            return super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

