/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.repository;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.UnclassifiedServerFailureException;
import ca.uhn.fhir.util.BundleBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.dstu3.AttachmentUtil;
import org.opencds.cqf.fhir.utility.matcher.ResourceMatcher;
import org.opencds.cqf.fhir.utility.repository.IGLayoutMode;
import org.opencds.cqf.fhir.utility.repository.Repositories;
import org.opencds.cqf.fhir.utility.repository.ResourceCategory;

public class IGFileStructureRepository
implements Repository {
    private final FhirContext fhirContext;
    private final String root;
    private final IGLayoutMode layoutMode;
    private final EncodingEnum encodingEnum;
    private final IParser parser;
    private final ResourceMatcher resourceMatcher;
    private final Map<String, IBaseResource> resourceCache = new HashMap<String, IBaseResource>();
    private static final Map<ResourceCategory, String> categoryDirectories = new ImmutableMap.Builder().put((Object)ResourceCategory.CONTENT, (Object)"resources").put((Object)ResourceCategory.DATA, (Object)"tests").put((Object)ResourceCategory.TERMINOLOGY, (Object)"vocabulary").build();
    private static final Map<EncodingEnum, String> fileExtensions = new ImmutableMap.Builder().put((Object)EncodingEnum.JSON, (Object)".json").put((Object)EncodingEnum.XML, (Object)".xml").put((Object)EncodingEnum.RDF, (Object)".rdf").build();

    private static IParser parserForEncoding(FhirContext fhirContext, EncodingEnum encodingEnum) {
        switch (encodingEnum) {
            case JSON: {
                return fhirContext.newJsonParser();
            }
            case XML: {
                return fhirContext.newXmlParser();
            }
            case RDF: {
                return fhirContext.newRDFParser();
            }
        }
        throw new IllegalArgumentException("NDJSON is not supported");
    }

    public IGFileStructureRepository(FhirContext fhirContext, String root) {
        this(fhirContext, root, IGLayoutMode.DIRECTORY, EncodingEnum.JSON);
    }

    public IGFileStructureRepository(FhirContext fhirContext, String root, IGLayoutMode layoutMode, EncodingEnum encodingEnum) {
        this.fhirContext = fhirContext;
        this.root = root;
        this.layoutMode = layoutMode;
        this.encodingEnum = encodingEnum;
        this.parser = IGFileStructureRepository.parserForEncoding(fhirContext, encodingEnum);
        this.resourceMatcher = Repositories.getResourceMatcher(this.fhirContext);
    }

    public void clearCache() {
        this.resourceCache.clear();
    }

    protected <T extends IBaseResource, I extends IIdType> String locationForResource(Class<T> resourceType, I id) {
        String directory = this.directoryForType(resourceType);
        return directory + "/" + this.fileNameForLayoutAndEncoding(resourceType.getSimpleName(), id.getIdPart());
    }

    protected String fileNameForLayoutAndEncoding(String resourceType, String resourceId) {
        String name = resourceId + fileExtensions.get(this.encodingEnum);
        if (this.layoutMode == IGLayoutMode.DIRECTORY) {
            return resourceType.toLowerCase() + "/" + name;
        }
        return resourceType + "-" + name;
    }

    protected <T extends IBaseResource> String directoryForType(Class<T> resourceType) {
        ResourceCategory category = ResourceCategory.forType(resourceType.getSimpleName());
        String directory = categoryDirectories.get((Object)category);
        return (String)(this.root.endsWith("/") ? this.root : this.root + "/") + directory;
    }

    protected <T extends IBaseResource> String directoryForResource(Class<T> resourceType) {
        String directory = this.directoryForType(resourceType);
        if (this.layoutMode == IGLayoutMode.DIRECTORY) {
            return directory + "/" + resourceType.getSimpleName().toLowerCase();
        }
        return directory;
    }

    protected <T extends IBaseResource, I extends IIdType> T readLocation(Class<T> resourceClass, String location) {
        return (T)this.resourceCache.computeIfAbsent(location, l -> {
            try {
                IBaseResource x = this.parser.parseResource(resourceClass, (InputStream)new FileInputStream((String)l));
                return this.handleLibrary((IBaseResource)x, (String)l);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected <T extends IBaseResource> T handleLibrary(T resource, String location) {
        if (resource.fhirType().equals("Library")) {
            switch (this.fhirContext.getVersion().getVersion()) {
                case DSTU3: {
                    String cqlLocation = AttachmentUtil.getCqlLocation(resource);
                    if (cqlLocation == null) break;
                    resource = AttachmentUtil.addData(resource, this.getCqlContent(location, cqlLocation));
                    break;
                }
                case R4: {
                    String cqlLocation = org.opencds.cqf.fhir.utility.r4.AttachmentUtil.getCqlLocation(resource);
                    if (cqlLocation == null) break;
                    resource = org.opencds.cqf.fhir.utility.r4.AttachmentUtil.addData(resource, this.getCqlContent(location, cqlLocation));
                    break;
                }
                case R5: {
                    String cqlLocation = org.opencds.cqf.fhir.utility.r5.AttachmentUtil.getCqlLocation(resource);
                    if (cqlLocation == null) break;
                    resource = org.opencds.cqf.fhir.utility.r5.AttachmentUtil.addData(resource, this.getCqlContent(location, cqlLocation));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("unsupported FHIR version: %s", this.fhirContext));
                }
            }
        }
        return resource;
    }

    protected String getCqlContent(String rootPath, String relativePath) {
        Path p = Paths.get(rootPath, new String[0]).getParent().resolve(relativePath).normalize();
        try {
            return Files.asCharSource((File)p.toFile(), (Charset)StandardCharsets.UTF_8).read();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected <T extends IBaseResource> MethodOutcome writeLocation(T resource, String location) {
        try (FileOutputStream os = new FileOutputStream(location);){
            String result = this.parser.encodeResourceToString(resource);
            os.write(result.getBytes());
            this.resourceCache.put(location, resource);
        }
        catch (IOException e) {
            throw new UnclassifiedServerFailureException(500, String.format("unable to write resource to location %s", location));
        }
        return new MethodOutcome(resource.getIdElement());
    }

    protected <T extends IBaseResource> Map<IIdType, T> readLocation(Class<T> resourceClass) {
        String location = this.directoryForResource(resourceClass);
        HashMap<IIdType, T> resources = new HashMap<IIdType, T>();
        File inputDir = new File(location);
        if (inputDir.isDirectory()) {
            for (File file : inputDir.listFiles()) {
                if (!this.layoutMode.equals((Object)IGLayoutMode.DIRECTORY) && (!this.layoutMode.equals((Object)IGLayoutMode.TYPE_PREFIX) || !file.getName().startsWith(resourceClass.getSimpleName() + "-"))) continue;
                try {
                    T r = this.readLocation(resourceClass, file.getPath());
                    if (!r.fhirType().equals(resourceClass.getSimpleName())) continue;
                    resources.put(r.getIdElement().toUnqualifiedVersionless(), r);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        return resources;
    }

    public FhirContext fhirContext() {
        return this.fhirContext;
    }

    public <T extends IBaseResource, I extends IIdType> T read(Class<T> resourceType, I id, Map<String, String> headers) {
        T r;
        String location;
        block5: {
            Objects.requireNonNull(resourceType, "resourceType can not be null");
            Objects.requireNonNull(id, "id can not be null");
            location = this.locationForResource(resourceType, id);
            r = null;
            try {
                r = this.readLocation(resourceType, location);
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof FileNotFoundException)) break block5;
                throw new ResourceNotFoundException(id);
            }
        }
        if (r == null) {
            throw new ResourceNotFoundException(id);
        }
        if (r.getIdElement() == null) {
            throw new ResourceNotFoundException(String.format("Expected to find a resource with id: %s at location: %s. Found resource without an id instead.", id.toUnqualifiedVersionless(), location));
        }
        if (!r.getIdElement().toUnqualifiedVersionless().equals((Object)id.toUnqualifiedVersionless())) {
            throw new ResourceNotFoundException(String.format("Expected to find a resource with id: %s at location: %s. Found resource with an id %s instead.", id.toUnqualifiedVersionless(), location, r.getIdElement().toUnqualifiedVersionless()));
        }
        return r;
    }

    public <T extends IBaseResource> MethodOutcome create(T resource, Map<String, String> headers) {
        Objects.requireNonNull(resource, "resource can not be null");
        Objects.requireNonNull(resource.getIdElement(), "resource id can not be null");
        String location = this.locationForResource(resource.getClass(), resource.getIdElement());
        return this.writeLocation(resource, location);
    }

    public <I extends IIdType, P extends IBaseParameters> MethodOutcome patch(I id, P patchParameters, Map<String, String> headers) {
        throw new UnsupportedOperationException("Unimplemented method 'patch'");
    }

    public <T extends IBaseResource> MethodOutcome update(T resource, Map<String, String> headers) {
        Objects.requireNonNull(resource, "resource can not be null");
        Objects.requireNonNull(resource.getIdElement(), "resource id can not be null");
        String location = this.locationForResource(resource.getClass(), resource.getIdElement());
        return this.writeLocation(resource, location);
    }

    public <T extends IBaseResource, I extends IIdType> MethodOutcome delete(Class<T> resourceType, I id, Map<String, String> headers) {
        Objects.requireNonNull(resourceType, "resourceType can not be null");
        Objects.requireNonNull(id, "id can not be null");
        String location = this.locationForResource(resourceType, id);
        try {
            new File(location).delete();
        }
        catch (Exception e) {
            throw new UnclassifiedServerFailureException(500, String.format("Couldn't delete %s", location));
        }
        return new MethodOutcome(id);
    }

    public <B extends IBaseBundle, T extends IBaseResource> B search(Class<B> bundleType, Class<T> resourceType, Map<String, List<IQueryParameterType>> searchParameters, Map<String, String> headers) {
        Collection<T> candidates;
        Map<IIdType, T> resourceIdMap;
        BundleBuilder builder;
        block9: {
            block8: {
                builder = new BundleBuilder(this.fhirContext);
                resourceIdMap = this.readLocation(resourceType);
                if (searchParameters == null) break block8;
                if (!searchParameters.isEmpty()) break block9;
            }
            resourceIdMap.values().forEach(arg_0 -> ((BundleBuilder)builder).addCollectionEntry(arg_0));
            builder.setType("searchset");
            return (B)builder.getBundle();
        }
        if (searchParameters.containsKey("_id")) {
            List<IQueryParameterType> idQueries = searchParameters.get("_id");
            searchParameters.remove("_id");
            ArrayList<T> idResources = new ArrayList<T>(idQueries.size());
            for (IQueryParameterType idQuery : idQueries) {
                TokenParam idToken = (TokenParam)idQuery;
                Object id = Ids.newId(this.fhirContext, resourceType.getSimpleName(), idToken.getValue());
                IBaseResource r = (IBaseResource)resourceIdMap.get(id);
                if (r == null) continue;
                idResources.add(r);
            }
            candidates = idResources;
        } else {
            candidates = resourceIdMap.values();
        }
        for (IBaseResource resource : candidates) {
            boolean include = true;
            for (Map.Entry<String, List<IQueryParameterType>> nextEntry : searchParameters.entrySet()) {
                String paramName = nextEntry.getKey();
                if (this.resourceMatcher.matches(paramName, nextEntry.getValue(), resource)) continue;
                include = false;
                break;
            }
            if (!include) continue;
            builder.addCollectionEntry(resource);
        }
        builder.setType("searchset");
        return (B)builder.getBundle();
    }

    public <B extends IBaseBundle> B link(Class<B> bundleType, String url, Map<String, String> headers) {
        throw new UnsupportedOperationException("Unimplemented method 'link'");
    }

    public <C extends IBaseConformance> C capabilities(Class<C> resourceType, Map<String, String> headers) {
        throw new UnsupportedOperationException("Unimplemented method 'capabilities'");
    }

    public <B extends IBaseBundle> B transaction(B transaction, Map<String, String> headers) {
        throw new UnsupportedOperationException("Unimplemented method 'transaction'");
    }

    public <R extends IBaseResource, P extends IBaseParameters> R invoke(String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        throw new UnsupportedOperationException("Unimplemented method 'invoke'");
    }

    public <P extends IBaseParameters> MethodOutcome invoke(String name, P parameters, Map<String, String> headers) {
        throw new UnsupportedOperationException("Unimplemented method 'invoke'");
    }

    public <R extends IBaseResource, P extends IBaseParameters, T extends IBaseResource> R invoke(Class<T> resourceType, String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        throw new UnsupportedOperationException("Unimplemented method 'invoke'");
    }

    public <P extends IBaseParameters, T extends IBaseResource> MethodOutcome invoke(Class<T> resourceType, String name, P parameters, Map<String, String> headers) {
        throw new UnsupportedOperationException("Unimplemented method 'invoke'");
    }

    public <R extends IBaseResource, P extends IBaseParameters, I extends IIdType> R invoke(I id, String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        throw new UnsupportedOperationException("Unimplemented method 'invoke'");
    }

    public <P extends IBaseParameters, I extends IIdType> MethodOutcome invoke(I id, String name, P parameters, Map<String, String> headers) {
        throw new UnsupportedOperationException("Unimplemented method 'invoke'");
    }

    public <B extends IBaseBundle, P extends IBaseParameters> B history(P parameters, Class<B> returnType, Map<String, String> headers) {
        throw new UnsupportedOperationException("Unimplemented method 'history'");
    }

    public <B extends IBaseBundle, P extends IBaseParameters, T extends IBaseResource> B history(Class<T> resourceType, P parameters, Class<B> returnType, Map<String, String> headers) {
        throw new UnsupportedOperationException("Unimplemented method 'history'");
    }

    public <B extends IBaseBundle, P extends IBaseParameters, I extends IIdType> B history(I id, P parameters, Class<B> returnType, Map<String, String> headers) {
        throw new UnsupportedOperationException("Unimplemented method 'history'");
    }
}

