/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.repository;

import com.google.common.collect.Sets;
import java.util.Set;

public enum ResourceCategory {
    DATA,
    TERMINOLOGY,
    CONTENT;

    private static final Set<String> TERMINOLOGY_RESOURCES;
    private static final Set<String> CONTENT_RESOURCES;

    public static ResourceCategory forType(String resourceType) {
        if (TERMINOLOGY_RESOURCES.contains(resourceType)) {
            return TERMINOLOGY;
        }
        if (CONTENT_RESOURCES.contains(resourceType)) {
            return CONTENT;
        }
        return DATA;
    }

    static {
        TERMINOLOGY_RESOURCES = Sets.newHashSet((Object[])new String[]{"ValueSet", "CodeSystem"});
        CONTENT_RESOURCES = Sets.newHashSet((Object[])new String[]{"Library", "Questionnaire", "Measure", "PlanDefinition", "StructureDefinition", "ActivityDefinition"});
    }
}

