/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.MethodOutcome;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.api.Repository;

public class ProxyRepository
implements Repository {
    private Repository local;
    private Repository data;
    private Repository content;
    private Repository terminology;
    private static Set<String> terminologyResourceSet = new HashSet<String>(Arrays.asList("ValueSet", "CodeSystem", "ConceptMap"));
    private static Set<String> contentResourceSet = new HashSet<String>(Arrays.asList("Library", "Measure", "PlanDefinition", "StructureDefinition", "ActivityDefinition", "Questionnaire"));

    public ProxyRepository(Repository local, Repository data, Repository content, Repository terminology) {
        Preconditions.checkNotNull((Object)local);
        this.local = local;
        this.data = data == null ? this.local : data;
        this.content = content == null ? this.local : content;
        this.terminology = terminology == null ? this.local : terminology;
    }

    public ProxyRepository(Repository data, Repository content, Repository terminology) {
        Preconditions.checkNotNull((Object)data);
        this.data = data;
        this.content = content == null ? this.data : content;
        this.terminology = terminology == null ? this.data : terminology;
    }

    public <T extends IBaseResource, I extends IIdType> T read(Class<T> resourceType, I id, Map<String, String> headers) {
        if (this.isTerminologyResource(resourceType.getSimpleName())) {
            return (T)this.terminology.read(resourceType, id, headers);
        }
        if (this.isContentResource(resourceType.getSimpleName())) {
            return (T)this.content.read(resourceType, id, headers);
        }
        return (T)this.data.read(resourceType, id, headers);
    }

    public <T extends IBaseResource> MethodOutcome create(T resource, Map<String, String> headers) {
        return null;
    }

    public <I extends IIdType, P extends IBaseParameters> MethodOutcome patch(I id, P patchParameters, Map<String, String> headers) {
        return null;
    }

    public <T extends IBaseResource> MethodOutcome update(T resource, Map<String, String> headers) {
        return null;
    }

    public <T extends IBaseResource, I extends IIdType> MethodOutcome delete(Class<T> resourceType, I id, Map<String, String> headers) {
        return null;
    }

    public <B extends IBaseBundle, T extends IBaseResource> B search(Class<B> bundleType, Class<T> resourceType, Map<String, List<IQueryParameterType>> searchParameters, Map<String, String> headers) {
        if (this.isTerminologyResource(resourceType.getSimpleName())) {
            return (B)this.terminology.search(bundleType, resourceType, searchParameters, headers);
        }
        if (this.isContentResource(resourceType.getSimpleName())) {
            return (B)this.content.search(bundleType, resourceType, searchParameters, headers);
        }
        return (B)this.data.search(bundleType, resourceType, searchParameters, headers);
    }

    public <B extends IBaseBundle> B link(Class<B> bundleType, String url, Map<String, String> headers) {
        return null;
    }

    public <C extends IBaseConformance> C capabilities(Class<C> resourceType, Map<String, String> headers) {
        return null;
    }

    public <B extends IBaseBundle> B transaction(B transaction, Map<String, String> headers) {
        return null;
    }

    public <R extends IBaseResource, P extends IBaseParameters> R invoke(String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        return null;
    }

    public <P extends IBaseParameters> MethodOutcome invoke(String name, P parameters, Map<String, String> headers) {
        return null;
    }

    public <R extends IBaseResource, P extends IBaseParameters, T extends IBaseResource> R invoke(Class<T> resourceType, String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        return null;
    }

    public <P extends IBaseParameters, T extends IBaseResource> MethodOutcome invoke(Class<T> resourceType, String name, P parameters, Map<String, String> headers) {
        return null;
    }

    public <R extends IBaseResource, P extends IBaseParameters, I extends IIdType> R invoke(I id, String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        return null;
    }

    public <P extends IBaseParameters, I extends IIdType> MethodOutcome invoke(I id, String name, P parameters, Map<String, String> headers) {
        return null;
    }

    public <B extends IBaseBundle, P extends IBaseParameters> B history(P parameters, Class<B> returnType, Map<String, String> headers) {
        return null;
    }

    public <B extends IBaseBundle, P extends IBaseParameters, T extends IBaseResource> B history(Class<T> resourceType, P parameters, Class<B> returnType, Map<String, String> headers) {
        return null;
    }

    public <B extends IBaseBundle, P extends IBaseParameters, I extends IIdType> B history(I id, P parameters, Class<B> returnType, Map<String, String> headers) {
        return null;
    }

    public FhirContext fhirContext() {
        return this.data.fhirContext();
    }

    private boolean isTerminologyResource(String type) {
        return terminologyResourceSet.contains(type);
    }

    private boolean isContentResource(String type) {
        return contentResourceSet.contains(type);
    }
}

