/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.util.BundleBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.iterable.BundleIterator;

public class FederatedRepository
implements Repository {
    private Repository local;
    private List<Repository> repositoryList;

    public FederatedRepository(Repository local, Repository ... repositories) {
        this.local = local;
        this.repositoryList = new ArrayList<Repository>();
        this.repositoryList.addAll(Arrays.asList(repositories));
    }

    public <T extends IBaseResource, I extends IIdType> T read(Class<T> resourceType, I id, Map<String, String> headers) {
        IBaseResource result = null;
        try {
            result = this.local.read(resourceType, id, headers);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            for (Repository repository : this.repositoryList) {
                try {
                    result = repository.read(resourceType, id, headers);
                    if (result == null) continue;
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        if (result == null) {
            throw new ResourceNotFoundException(String.format("No resource found with id: %s", id.getValue()));
        }
        return (T)result;
    }

    public <T extends IBaseResource> MethodOutcome create(T resource, Map<String, String> headers) {
        return null;
    }

    public <I extends IIdType, P extends IBaseParameters> MethodOutcome patch(I id, P patchParameters, Map<String, String> headers) {
        return null;
    }

    public <T extends IBaseResource> MethodOutcome update(T resource, Map<String, String> headers) {
        return null;
    }

    public <T extends IBaseResource, I extends IIdType> MethodOutcome delete(Class<T> resourceType, I id, Map<String, String> headers) {
        return null;
    }

    private <B extends IBaseBundle, T extends IBaseResource> List<T> conductSearch(Repository repository, Class<B> bundleType, Class<T> resourceType, Map<String, List<IQueryParameterType>> searchParameters, Map<String, String> headers) {
        ArrayList results = new ArrayList();
        IBaseBundle bundle = repository.search(bundleType, resourceType, searchParameters, headers);
        BundleIterator<IBaseBundle> iterator = new BundleIterator<IBaseBundle>(repository, bundleType, bundle);
        iterator.forEachRemaining(b -> results.add(b.getResource()));
        return results;
    }

    public <B extends IBaseBundle, T extends IBaseResource> B search(Class<B> bundleType, Class<T> resourceType, Map<String, List<IQueryParameterType>> searchParameters, Map<String, String> headers) {
        BundleBuilder builder = new BundleBuilder(this.fhirContext());
        ArrayList<CompletableFuture<List>> futureList = new ArrayList<CompletableFuture<List>>();
        futureList.add(CompletableFuture.supplyAsync(() -> this.conductSearch(this.local, bundleType, resourceType, searchParameters, headers)));
        this.repositoryList.forEach(r -> futureList.add(CompletableFuture.supplyAsync(() -> this.conductSearch((Repository)r, bundleType, resourceType, searchParameters, headers))));
        CompletableFuture[] futureArray = futureList.toArray(new CompletableFuture[futureList.size()]);
        CompletableFuture<Void> resultsFuture = CompletableFuture.allOf(futureArray);
        try {
            resultsFuture.get();
            List<IBaseResource> resources = Stream.of(futureArray).map(CompletableFuture::join).map(b -> (List)b).flatMap(b -> b.stream()).collect(Collectors.toList());
            resources.forEach(arg_0 -> ((BundleBuilder)builder).addCollectionEntry(arg_0));
            builder.setType("searchset");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (B)builder.getBundleTyped();
    }

    public <B extends IBaseBundle> B link(Class<B> bundleType, String url, Map<String, String> headers) {
        return null;
    }

    public <C extends IBaseConformance> C capabilities(Class<C> resourceType, Map<String, String> headers) {
        return null;
    }

    public <B extends IBaseBundle> B transaction(B transaction, Map<String, String> headers) {
        return null;
    }

    public <R extends IBaseResource, P extends IBaseParameters> R invoke(String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        return null;
    }

    public <P extends IBaseParameters> MethodOutcome invoke(String name, P parameters, Map<String, String> headers) {
        return null;
    }

    public <R extends IBaseResource, P extends IBaseParameters, T extends IBaseResource> R invoke(Class<T> resourceType, String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        return null;
    }

    public <P extends IBaseParameters, T extends IBaseResource> MethodOutcome invoke(Class<T> resourceType, String name, P parameters, Map<String, String> headers) {
        return null;
    }

    public <R extends IBaseResource, P extends IBaseParameters, I extends IIdType> R invoke(I id, String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        return null;
    }

    public <P extends IBaseParameters, I extends IIdType> MethodOutcome invoke(I id, String name, P parameters, Map<String, String> headers) {
        return null;
    }

    public <B extends IBaseBundle, P extends IBaseParameters> B history(P parameters, Class<B> returnType, Map<String, String> headers) {
        return null;
    }

    public <B extends IBaseBundle, P extends IBaseParameters, T extends IBaseResource> B history(Class<T> resourceType, P parameters, Class<B> returnType, Map<String, String> headers) {
        return null;
    }

    public <B extends IBaseBundle, P extends IBaseParameters, I extends IIdType> B history(I id, P parameters, Class<B> returnType, Map<String, String> headers) {
        return null;
    }

    public FhirContext fhirContext() {
        return this.local.fhirContext();
    }
}

