/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.iterable;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.bundle.BundleEntryParts;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.opencds.cqf.fhir.api.Repository;

public class BundleIterator<B extends IBaseBundle>
implements Iterator<BundleEntryParts> {
    protected Repository repository;
    protected B bundle;
    protected int index = 0;
    protected List<BundleEntryParts> parts;
    protected Class<B> bundleType;

    public BundleIterator(Repository repository, Class<B> bundleType, B bundle) {
        this.repository = repository;
        this.bundle = bundle;
        this.bundleType = bundleType;
        this.parts = BundleUtil.toListOfEntries((FhirContext)repository.fhirContext(), bundle);
    }

    @Override
    public boolean hasNext() {
        return this.parts.size() > this.index;
    }

    @Override
    public BundleEntryParts next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        BundleEntryParts next = this.parts.get(this.index);
        ++this.index;
        if (this.index >= this.parts.size()) {
            this.getNextBundle();
        }
        return next;
    }

    protected void getNextBundle() {
        String nextLink = BundleUtil.getLinkUrlOfType((FhirContext)this.repository.fhirContext(), this.bundle, (String)"next");
        if (nextLink == null) {
            return;
        }
        this.index = 0;
        this.bundle = this.repository.link(this.bundleType, nextLink);
        this.parts = this.bundle == null ? Collections.emptyList() : BundleUtil.toListOfEntries((FhirContext)this.repository.fhirContext(), this.bundle);
    }
}

