/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.primitive.IdDt;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.IdType;
import org.opencds.cqf.fhir.utility.FhirVersions;

public class Ids {
    private Ids() {
    }

    public static <ResourceType extends IBaseResource, IdType extends IIdType> IdType newId(Class<? extends ResourceType> theResourceTypeClass, String theId) {
        Preconditions.checkNotNull(theResourceTypeClass);
        Preconditions.checkNotNull((Object)theId);
        FhirVersionEnum versionEnum = FhirVersions.forClass(theResourceTypeClass);
        return Ids.newId(versionEnum, theResourceTypeClass.getSimpleName(), theId);
    }

    public static <BaseType extends IBase, IdType extends IIdType> IdType newId(Class<? extends BaseType> theBaseTypeClass, String theResourceName, String theId) {
        Preconditions.checkNotNull(theBaseTypeClass);
        Preconditions.checkNotNull((Object)theResourceName);
        Preconditions.checkNotNull((Object)theId);
        FhirVersionEnum versionEnum = FhirVersions.forClass(theBaseTypeClass);
        return Ids.newId(versionEnum, theResourceName, theId);
    }

    public static <IdType extends IIdType> IdType newRandomId(FhirContext theFhirContext, String theResourceType) {
        Preconditions.checkNotNull((Object)theFhirContext);
        Preconditions.checkNotNull((Object)theResourceType);
        return Ids.newId(theFhirContext.getVersion().getVersion(), theResourceType, UUID.randomUUID().toString());
    }

    public static <IdType extends IIdType> IdType newId(FhirContext theFhirContext, String theResourceType, String theId) {
        Preconditions.checkNotNull((Object)theFhirContext);
        Preconditions.checkNotNull((Object)theResourceType);
        Preconditions.checkNotNull((Object)theId);
        return Ids.newId(theFhirContext.getVersion().getVersion(), theResourceType, theId);
    }

    public static <IdType extends IIdType> IdType newId(FhirVersionEnum theFhirVersionEnum, String theResourceType, String theIdPart) {
        Preconditions.checkNotNull((Object)theFhirVersionEnum);
        Preconditions.checkNotNull((Object)theResourceType);
        Preconditions.checkNotNull((Object)theIdPart);
        return Ids.newId(theFhirVersionEnum, theResourceType + "/" + theIdPart);
    }

    public static <IdType extends IIdType> IdType newId(FhirContext theFhirContext, String theId) {
        Preconditions.checkNotNull((Object)theFhirContext);
        Preconditions.checkNotNull((Object)theId);
        return Ids.newId(theFhirContext.getVersion().getVersion(), theId);
    }

    public static String simple(IBaseResource resource) {
        Preconditions.checkNotNull((Object)resource);
        Preconditions.checkArgument((resource.getIdElement() != null ? 1 : 0) != 0);
        return Ids.simple(resource.getIdElement());
    }

    public static String simple(IIdType id) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkArgument((boolean)id.hasResourceType());
        Preconditions.checkArgument((boolean)id.hasIdPart());
        return id.toUnqualifiedVersionless().getValue();
    }

    public static String simplePart(IBaseResource resource) {
        Preconditions.checkNotNull((Object)resource);
        Preconditions.checkArgument((resource.getIdElement() != null ? 1 : 0) != 0);
        return Ids.simplePart(resource.getIdElement());
    }

    public static String simplePart(IIdType id) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkArgument((boolean)id.hasResourceType());
        Preconditions.checkArgument((boolean)id.hasIdPart());
        return id.toUnqualifiedVersionless().getIdPart();
    }

    public static <IdType extends IIdType> IdType newId(FhirVersionEnum theFhirVersionEnum, String theId) {
        Preconditions.checkNotNull((Object)theFhirVersionEnum);
        Preconditions.checkNotNull((Object)theId);
        switch (theFhirVersionEnum) {
            case DSTU2: {
                return (IdType)new IdDt(theId);
            }
            case DSTU2_1: {
                return (IdType)new org.hl7.fhir.dstu2016may.model.IdType(theId);
            }
            case DSTU2_HL7ORG: {
                return (IdType)new org.hl7.fhir.dstu2.model.IdType(theId);
            }
            case DSTU3: {
                return (IdType)new org.hl7.fhir.dstu3.model.IdType(theId);
            }
            case R4: {
                return (IdType)new IdType(theId);
            }
            case R4B: {
                return (IdType)new org.hl7.fhir.r4b.model.IdType(theId);
            }
            case R5: {
                return (IdType)new org.hl7.fhir.r5.model.IdType(theId);
            }
        }
        throw new IllegalArgumentException(String.format("newId does not support FHIR version %s", theFhirVersionEnum.getFhirVersionString()));
    }
}

