/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.behavior;

import com.google.common.base.Preconditions;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.behavior.FhirContextUser;

public interface ResourceCreator
extends FhirContextUser {
    default public <T extends IBaseResource, I extends IIdType> T newResource(I theId) {
        Preconditions.checkNotNull(theId, (Object)"theId is required");
        Preconditions.checkArgument((theId.getResourceType() != null ? 1 : 0) != 0, (Object)"theId must have a resourceType");
        IBaseResource newResource = (IBaseResource)this.getFhirContext().getResourceDefinition(theId.getResourceType()).newInstance();
        newResource.setId(theId);
        return (T)newResource;
    }

    default public <T extends IBaseResource> T newResource(Class<T> theResourceClass, String theIdPart) {
        Preconditions.checkNotNull(theResourceClass);
        Preconditions.checkNotNull((Object)theIdPart);
        T newResource = this.newResource(theResourceClass);
        Object id = Ids.newId(this.getFhirContext(), newResource.fhirType(), theIdPart);
        newResource.setId(id);
        return newResource;
    }

    default public <T extends IBaseResource> T newResource(Class<T> theResourceClass) {
        Preconditions.checkNotNull(theResourceClass);
        return (T)((IBaseResource)this.getFhirContext().getResourceDefinition(theResourceClass).newInstance());
    }

    default public <T extends IBaseResource> T newResource(String theResourceType) {
        Preconditions.checkNotNull((Object)theResourceType);
        return (T)((IBaseResource)this.getFhirContext().getResourceDefinition(theResourceType).newInstance());
    }
}

