/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.builder;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.dstu3.model.DetectedIssue;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.r4.model.DetectedIssue;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.opencds.cqf.fhir.utility.builder.CodeableConceptSettings;
import org.opencds.cqf.fhir.utility.builder.CodingSettings;
import org.opencds.cqf.fhir.utility.builder.DomainResourceBuilder;

public class DetectedIssueBuilder<T extends IDomainResource>
extends DomainResourceBuilder<DetectedIssueBuilder<T>, T> {
    private String myStatus;
    private CodeableConceptSettings myCode;
    private String myPatient;
    private List<String> myEvidenceDetail;

    public DetectedIssueBuilder(Class<T> theResourceClass) {
        super(theResourceClass);
    }

    public DetectedIssueBuilder(Class<T> theResourceClass, String theId) {
        super(theResourceClass, theId);
    }

    public DetectedIssueBuilder(Class<T> theResourceClass, String theId, String theStatus, String theEvidenceDetail) {
        super(theResourceClass, theId);
        Preconditions.checkNotNull((Object)theStatus, (Object)theEvidenceDetail);
        this.myStatus = theStatus;
        this.addEvidenceDetail(theEvidenceDetail);
    }

    private void addEvidenceDetail(String theEvidenceDetail) {
        if (this.myEvidenceDetail == null) {
            this.myEvidenceDetail = new ArrayList<String>();
        }
        this.myEvidenceDetail.add(theEvidenceDetail);
    }

    private List<String> getEvidenceDetails() {
        if (this.myEvidenceDetail == null) {
            return Collections.emptyList();
        }
        return this.myEvidenceDetail;
    }

    public DetectedIssueBuilder<T> withStatus(String theStatus) {
        this.myStatus = theStatus;
        return this;
    }

    public DetectedIssueBuilder<T> withCode(CodeableConceptSettings theCode) {
        Preconditions.checkNotNull((Object)theCode);
        this.myCode = theCode;
        return this;
    }

    public DetectedIssueBuilder<T> withPatient(String thePatient) {
        this.myPatient = DetectedIssueBuilder.ensurePatientReference(thePatient);
        return this;
    }

    public DetectedIssueBuilder<T> withEvidenceDetail(String theEvidenceDetail) {
        Preconditions.checkNotNull((Object)theEvidenceDetail);
        this.addEvidenceDetail(theEvidenceDetail);
        return this;
    }

    @Override
    public T build() {
        Preconditions.checkNotNull((Object)this.myStatus, this.myEvidenceDetail);
        Preconditions.checkArgument((!this.myEvidenceDetail.isEmpty() ? 1 : 0) != 0);
        return (T)((IDomainResource)super.build());
    }

    private CodingSettings getCodeSetting() {
        return this.myCode.getCodingSettingsArray()[0];
    }

    @Override
    protected void initializeDstu3(T theResource) {
        super.initializeDstu3(theResource);
        org.hl7.fhir.dstu3.model.DetectedIssue detectedIssue = (org.hl7.fhir.dstu3.model.DetectedIssue)theResource;
        detectedIssue.setIdentifier(new Identifier().setSystem((String)this.getIdentifier().getKey()).setValue((String)this.getIdentifier().getValue())).setPatient(new Reference(this.myPatient)).setStatus(DetectedIssue.DetectedIssueStatus.valueOf((String)this.myStatus));
        this.getEvidenceDetails().forEach(arg_0 -> ((org.hl7.fhir.dstu3.model.DetectedIssue)detectedIssue).setReference(arg_0));
    }

    @Override
    protected void initializeR4(T theResource) {
        super.initializeR4(theResource);
        DetectedIssue detectedIssue = (DetectedIssue)theResource;
        ArrayList<org.hl7.fhir.r4.model.Identifier> identifier = new ArrayList<org.hl7.fhir.r4.model.Identifier>();
        identifier.add(new org.hl7.fhir.r4.model.Identifier().setSystem((String)this.getIdentifier().getKey()).setValue((String)this.getIdentifier().getValue()));
        detectedIssue.setIdentifier(identifier).setPatient(new org.hl7.fhir.r4.model.Reference(this.myPatient)).setStatus(DetectedIssue.DetectedIssueStatus.valueOf((String)this.myStatus)).setCode(new org.hl7.fhir.r4.model.CodeableConcept().addCoding(new org.hl7.fhir.r4.model.Coding().setSystem(this.getCodeSetting().getSystem()).setCode(this.getCodeSetting().getCode()).setDisplay(this.getCodeSetting().getDisplay())));
        this.getEvidenceDetails().forEach(evidence -> detectedIssue.addEvidence(new DetectedIssue.DetectedIssueEvidenceComponent().addDetail(new org.hl7.fhir.r4.model.Reference(evidence))));
    }

    @Override
    protected void initializeR5(T theResource) {
        super.initializeR5(theResource);
        org.hl7.fhir.r5.model.DetectedIssue detectedIssue = (org.hl7.fhir.r5.model.DetectedIssue)theResource;
        ArrayList<org.hl7.fhir.r5.model.Identifier> identifier = new ArrayList<org.hl7.fhir.r5.model.Identifier>();
        identifier.add(new org.hl7.fhir.r5.model.Identifier().setSystem((String)this.getIdentifier().getKey()).setValue((String)this.getIdentifier().getValue()));
        detectedIssue.setIdentifier(identifier).setStatus(DetectedIssue.DetectedIssueStatus.valueOf((String)this.myStatus)).setCode(new CodeableConcept().addCoding(new Coding().setSystem(this.getCodeSetting().getSystem()).setCode(this.getCodeSetting().getCode()).setDisplay(this.getCodeSetting().getDisplay())));
        this.getEvidenceDetails().forEach(evidence -> detectedIssue.addEvidence(new DetectedIssue.DetectedIssueEvidenceComponent().addDetail(new org.hl7.fhir.r5.model.Reference(evidence))));
    }
}

