/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.builder;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.opencds.cqf.fhir.utility.builder.CodeableConceptSettings;
import org.opencds.cqf.fhir.utility.builder.ResourceBuilder;

public abstract class DomainResourceBuilder<SELF, T extends IDomainResource>
extends ResourceBuilder<SELF, T> {
    private List<Pair<String, CodeableConceptSettings>> myExtension;
    private List<Pair<String, CodeableConceptSettings>> myModifierExtension;

    protected DomainResourceBuilder(Class<T> theResourceClass) {
        super(theResourceClass);
    }

    protected DomainResourceBuilder(Class<T> theResourceClass, String theId) {
        super(theResourceClass, theId);
    }

    private void addExtension(Pair<String, CodeableConceptSettings> theExtension) {
        if (this.myExtension == null) {
            this.myExtension = new ArrayList<Pair<String, CodeableConceptSettings>>();
        }
        this.myExtension.add(theExtension);
    }

    private List<Pair<String, CodeableConceptSettings>> getExtensions() {
        if (this.myExtension == null) {
            return Collections.emptyList();
        }
        return this.myExtension;
    }

    private void addModifierExtension(Pair<String, CodeableConceptSettings> theModifierExtension) {
        if (this.myModifierExtension == null) {
            this.myModifierExtension = new ArrayList<Pair<String, CodeableConceptSettings>>();
        }
        this.myModifierExtension.add(theModifierExtension);
    }

    private List<Pair<String, CodeableConceptSettings>> getModifierExtensions() {
        if (this.myModifierExtension == null) {
            return Collections.emptyList();
        }
        return this.myModifierExtension;
    }

    public SELF withExtension(Pair<String, CodeableConceptSettings> theExtension) {
        Preconditions.checkNotNull(theExtension);
        this.addExtension(theExtension);
        return this.self();
    }

    public SELF withModifierExtension(Pair<String, CodeableConceptSettings> theModifierExtension) {
        Preconditions.checkNotNull(theModifierExtension);
        this.addModifierExtension(theModifierExtension);
        return this.self();
    }

    @Override
    protected SELF self() {
        return (SELF)this;
    }

    @Override
    protected void initializeDstu3(T theResource) {
        super.initializeDstu3(theResource);
        this.getExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept = new org.hl7.fhir.dstu3.model.CodeableConcept().addCoding(new Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension extension = theResource.addExtension();
            extension.setUrl((String)extensionSetting.getKey());
            extension.setValue((IBaseDatatype)codeableConcept);
        }));
        this.getModifierExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept = new org.hl7.fhir.dstu3.model.CodeableConcept().addCoding(new Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension modifierExtension = theResource.addModifierExtension();
            modifierExtension.setUrl((String)extensionSetting.getKey());
            modifierExtension.setValue((IBaseDatatype)codeableConcept);
        }));
    }

    @Override
    protected void initializeR4(T theResource) {
        super.initializeR4(theResource);
        this.getExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            CodeableConcept codeableConcept = new CodeableConcept().addCoding(new org.hl7.fhir.r4.model.Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension extension = theResource.addExtension();
            extension.setUrl((String)extensionSetting.getKey());
            extension.setValue((IBaseDatatype)codeableConcept);
        }));
        this.getModifierExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            CodeableConcept codeableConcept = new CodeableConcept().addCoding(new org.hl7.fhir.r4.model.Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension modifierExtension = theResource.addModifierExtension();
            modifierExtension.setUrl((String)extensionSetting.getKey());
            modifierExtension.setValue((IBaseDatatype)codeableConcept);
        }));
    }

    @Override
    protected void initializeR5(T theResource) {
        super.initializeR5(theResource);
        this.getExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            org.hl7.fhir.r5.model.CodeableConcept codeableConcept = new org.hl7.fhir.r5.model.CodeableConcept().addCoding(new org.hl7.fhir.r5.model.Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension extension = theResource.addExtension();
            extension.setUrl((String)extensionSetting.getKey());
            extension.setValue((IBaseDatatype)codeableConcept);
        }));
        this.getModifierExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            org.hl7.fhir.r5.model.CodeableConcept codeableConcept = new org.hl7.fhir.r5.model.CodeableConcept().addCoding(new org.hl7.fhir.r5.model.Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension modifierExtension = theResource.addModifierExtension();
            modifierExtension.setUrl((String)extensionSetting.getKey());
            modifierExtension.setValue((IBaseDatatype)codeableConcept);
        }));
    }
}

