/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.dstu3;

import ca.uhn.fhir.context.FhirContext;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.DataRequirement;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.dstu3.Parameters;
import org.opencds.cqf.fhir.utility.repository.FederatedRepository;
import org.opencds.cqf.fhir.utility.repository.InMemoryFhirRepository;
import org.opencds.cqf.fhir.utility.search.Searches;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputParameterResolver {
    private static final Logger logger = LoggerFactory.getLogger(InputParameterResolver.class);
    private final String subjectId;
    private final String encounterId;
    private final String practitionerId;
    private final org.hl7.fhir.dstu3.model.Parameters parameters;
    private final Repository repository;

    public InputParameterResolver(String subjectId, String encounterId, String practitionerId, IBaseParameters parameters, Boolean useServerData, IBaseBundle bundle, Repository repository) {
        this.subjectId = subjectId;
        this.encounterId = encounterId;
        this.practitionerId = practitionerId;
        InMemoryFhirRepository bundleRepository = null;
        if (bundle != null) {
            bundleRepository = new InMemoryFhirRepository(repository.fhirContext(), bundle);
        }
        this.repository = this.resolveRepository(useServerData, repository, bundleRepository);
        this.parameters = this.resolveParameters(parameters);
    }

    private Repository resolveRepository(Boolean useServerData, Repository serverRepository, Repository bundleRepository) {
        if (bundleRepository == null) {
            return serverRepository;
        }
        return Boolean.TRUE.equals(useServerData) ? new FederatedRepository(serverRepository, bundleRepository) : bundleRepository;
    }

    private FhirContext fhirContext() {
        return this.repository.fhirContext();
    }

    private <R extends IBaseResource> R readRepository(Class<R> resourceType, String id) {
        try {
            return (R)this.repository.read(resourceType, (IIdType)new IdType(id), null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private org.hl7.fhir.dstu3.model.Parameters resolveParameters(IBaseParameters baseParameters) {
        Practitioner practitioner;
        Encounter encounter;
        org.hl7.fhir.dstu3.model.Parameters params = Parameters.parameters(new Parameters.ParametersParameterComponent[0]);
        if (baseParameters != null) {
            params.getParameter().addAll(((org.hl7.fhir.dstu3.model.Parameters)baseParameters).getParameter());
        }
        String subjectType = this.subjectId.contains("/") ? this.subjectId.split("/")[0] : "Patient";
        Class subjectClass = this.fhirContext().getResourceDefinition(subjectType).getImplementingClass();
        Object subject = this.readRepository(subjectClass, this.subjectId);
        if (subject != null) {
            params.addParameter(Parameters.part("%subject", (Resource)subject, new Parameters.ParametersParameterComponent[0]));
        }
        if (this.encounterId != null && !this.encounterId.isEmpty() && (encounter = this.readRepository(Encounter.class, this.encounterId)) != null) {
            params.addParameter(Parameters.part("%encounter", (Resource)encounter, new Parameters.ParametersParameterComponent[0]));
        }
        if (this.practitionerId != null && !this.practitionerId.isEmpty() && (practitioner = this.readRepository(Practitioner.class, this.practitionerId)) != null) {
            params.addParameter(Parameters.part("%practitioner", (Resource)practitioner, new Parameters.ParametersParameterComponent[0]));
        }
        return params;
    }

    public org.hl7.fhir.dstu3.model.Parameters getParameters() {
        return this.parameters;
    }

    public org.hl7.fhir.dstu3.model.Parameters resolveInputParameters(List<DataRequirement> dataRequirements) {
        org.hl7.fhir.dstu3.model.Parameters params = Parameters.parameters(new Parameters.ParametersParameterComponent[0]);
        if (this.parameters != null) {
            params.getParameter().addAll(this.parameters.getParameter());
        }
        for (DataRequirement req : dataRequirements) {
            if (!req.hasId()) continue;
            Parameters.ParametersParameterComponent parameter = Parameters.part("%" + String.format("%s", req.getId()), new Parameters.ParametersParameterComponent[0]);
            if (req.hasCodeFilter()) {
                for (DataRequirement.DataRequirementCodeFilterComponent filter : req.getCodeFilter()) {
                    if (filter == null || !filter.hasPath() || !filter.hasValueSet()) continue;
                    Bundle valueSets = (Bundle)this.repository.search(Bundle.class, ValueSet.class, Searches.byCanonical(filter.getValueSet().primitiveValue()));
                    if (valueSets.hasEntry()) {
                        ValueSet valueSet = (ValueSet)valueSets.getEntryFirstRep().getResource();
                        ArrayList codes = valueSet.hasExpansion() ? valueSet.getExpansion().getContains().stream().map(c -> new Coding(c.getSystem(), c.getCode(), c.getDisplay())).collect(Collectors.toList()) : new ArrayList();
                        Searches.SearchBuilder searchBuilder = Searches.builder();
                        codes.forEach(c -> searchBuilder.withTokenParam("code", c.getCode()));
                        Class resourceType = this.fhirContext().getResourceDefinition(req.getType()).getImplementingClass();
                        Bundle searchResults = (Bundle)this.repository.search(Bundle.class, resourceType, searchBuilder.build(), null);
                        if (searchResults.hasEntry()) {
                            parameter.setResource((Resource)(searchResults.getEntry().size() > 1 ? searchResults : ((Bundle.BundleEntryComponent)searchResults.getEntry().get(0)).getResource()));
                        }
                    }
                    logger.debug("Could not find ValueSet with url {} on the local server.", (Object)filter.getValueSet());
                }
            }
            params.addParameter(parameter);
        }
        return params;
    }
}

