/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.matcher;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.InternalCodingDt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.opencds.cqf.fhir.utility.FhirPathCache;
import org.opencds.cqf.fhir.utility.matcher.ResourceMatcher;

public class ResourceMatcherDSTU3
implements ResourceMatcher {
    private Map<ResourceMatcher.SPPathKey, IFhirPath.IParsedExpression> pathCache = new HashMap<ResourceMatcher.SPPathKey, IFhirPath.IParsedExpression>();

    @Override
    public IFhirPath getEngine() {
        return FhirPathCache.cachedForVersion(FhirVersionEnum.DSTU3);
    }

    @Override
    public FhirContext getContext() {
        return FhirContext.forDstu3Cached();
    }

    @Override
    public DateRangeParam getDateRange(ICompositeType type) {
        if (type instanceof Period) {
            return new DateRangeParam(((Period)type).getStart(), ((Period)type).getEnd());
        }
        if (type instanceof Timing) {
            throw new NotImplementedException("Timing resolution has not yet been implemented");
        }
        throw new UnsupportedOperationException("Expected element of type Period or Timing, found " + type.getClass().getSimpleName());
    }

    @Override
    public List<BaseCodingDt> getCodes(IBase codeElement) {
        List<Object> resolvedCodes = new ArrayList<BaseCodingDt>();
        if (codeElement instanceof Coding) {
            resolvedCodes.add((BaseCodingDt)new InternalCodingDt(((Coding)codeElement).getSystem(), ((Coding)codeElement).getCode()));
        } else if (codeElement instanceof CodeType) {
            resolvedCodes.add((BaseCodingDt)new InternalCodingDt().setCode((String)((CodeType)codeElement).getValue()));
        } else if (codeElement instanceof CodeableConcept) {
            resolvedCodes = ((CodeableConcept)codeElement).getCoding().stream().map(code -> new InternalCodingDt(code.getSystem(), code.getCode())).collect(Collectors.toList());
        } else {
            return null;
        }
        return resolvedCodes;
    }

    @Override
    public boolean inValueSet(List<BaseCodingDt> codes) {
        throw new UnsupportedOperationException("InValueSet operation is not available");
    }

    @Override
    public Map<ResourceMatcher.SPPathKey, IFhirPath.IParsedExpression> getPathCache() {
        return this.pathCache;
    }
}

