/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.repository;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.util.BundleBuilder;
import ca.uhn.fhir.util.BundleUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.repository.Repositories;

public class InMemoryFhirRepository
implements Repository {
    private final Map<String, Map<IIdType, IBaseResource>> resourceMap;
    private final FhirContext context;

    public InMemoryFhirRepository(FhirContext context) {
        this.context = context;
        this.resourceMap = new HashMap<String, Map<IIdType, IBaseResource>>();
    }

    public InMemoryFhirRepository(FhirContext context, Class<?> clazz, List<String> directoryList, boolean recursive) {
        this.context = context;
        this.resourceMap = new HashMap<String, Map<IIdType, IBaseResource>>();
    }

    public InMemoryFhirRepository(FhirContext context, IBaseBundle bundle) {
        this.context = context;
        List resources = BundleUtil.toListOfResources((FhirContext)this.context, (IBaseBundle)bundle);
        this.resourceMap = resources.stream().collect(Collectors.groupingBy(IBase::fhirType, Collectors.toMap(r -> r.getIdElement().toUnqualifiedVersionless(), Function.identity())));
    }

    public <T extends IBaseResource, I extends IIdType> T read(Class<T> resourceType, I id, Map<String, String> headers) {
        Map resources = this.resourceMap.computeIfAbsent(resourceType.getSimpleName(), x -> new HashMap());
        IBaseResource resource = (IBaseResource)resources.get(id.toUnqualifiedVersionless());
        if (resource == null) {
            throw new ResourceNotFoundException(id);
        }
        return (T)resource;
    }

    public <T extends IBaseResource> MethodOutcome create(T resource, Map<String, String> headers) {
        MethodOutcome outcome = new MethodOutcome();
        Map resources = this.resourceMap.computeIfAbsent(resource.fhirType(), r -> new HashMap());
        Object theId = Ids.newRandomId(this.context, resource.fhirType());
        while (resources.containsKey(theId)) {
            theId = Ids.newRandomId(this.context, resource.fhirType());
        }
        resource.setId(theId);
        outcome.setCreated(Boolean.valueOf(true));
        resources.put(theId.toUnqualifiedVersionless(), resource);
        return outcome;
    }

    public <I extends IIdType, P extends IBaseParameters> MethodOutcome patch(I id, P patchParameters, Map<String, String> headers) {
        throw new NotImplementedException("The PATCH operation is not currently supported");
    }

    public <T extends IBaseResource> MethodOutcome update(T resource, Map<String, String> headers) {
        IIdType theId;
        MethodOutcome outcome = new MethodOutcome();
        Map resources = this.resourceMap.computeIfAbsent(resource.fhirType(), r -> new HashMap());
        if (!resources.containsKey(theId = resource.getIdElement().toUnqualifiedVersionless())) {
            outcome.setCreated(Boolean.valueOf(true));
        }
        resources.put(theId, resource);
        return outcome;
    }

    public <T extends IBaseResource, I extends IIdType> MethodOutcome delete(Class<T> resourceType, I id, Map<String, String> headers) {
        IIdType keyId;
        MethodOutcome outcome = new MethodOutcome();
        Map resources = this.resourceMap.computeIfAbsent(id.getResourceType(), r -> new HashMap());
        if (!resources.containsKey(keyId = id.toUnqualifiedVersionless())) {
            throw new ResourceNotFoundException("Resource not found with id " + id);
        }
        resources.remove(keyId);
        return outcome;
    }

    /*
     * Unable to fully structure code
     */
    public <B extends IBaseBundle, T extends IBaseResource> B search(Class<B> bundleType, Class<T> resourceType, Map<String, List<IQueryParameterType>> searchParameters, Map<String, String> headers) {
        builder = new BundleBuilder(this.context);
        resourceList = this.resourceMap.computeIfAbsent(resourceType.getSimpleName(), (Function<String, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$search$5(java.lang.String ), (Ljava/lang/String;)Ljava/util/Map;)()).values();
        if (searchParameters == null) ** GOTO lbl8
        if (searchParameters.isEmpty()) {
lbl8:
            // 2 sources

            resourceList.forEach((Consumer<IBaseResource>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, addCollectionEntry(org.hl7.fhir.instance.model.api.IBaseResource ), (Lorg/hl7/fhir/instance/model/api/IBaseResource;)V)((BundleBuilder)builder));
        } else {
            resourceMatcher = Repositories.getResourceMatcher(this.context);
            for (IBaseResource resource : resourceList) {
                include = true;
                for (Map.Entry<String, List<IQueryParameterType>> nextEntry : searchParameters.entrySet()) {
                    paramName = nextEntry.getKey();
                    if (resourceMatcher.matches(paramName, nextEntry.getValue(), resource)) continue;
                    include = false;
                    break;
                }
                if (!include) continue;
                builder.addCollectionEntry(resource);
            }
        }
        builder.setType("searchset");
        return (B)builder.getBundle();
    }

    public <B extends IBaseBundle> B link(Class<B> bundleType, String url, Map<String, String> headers) {
        throw new NotImplementedException("Paging is not currently supported");
    }

    public <C extends IBaseConformance> C capabilities(Class<C> resourceType, Map<String, String> headers) {
        throw new NotImplementedException("The capabilities interaction is not currently supported");
    }

    public <B extends IBaseBundle> B transaction(B transaction, Map<String, String> headers) {
        throw new NotImplementedException("The transaction operation is not currently supported");
    }

    public <R extends IBaseResource, P extends IBaseParameters> R invoke(String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        throw new NotImplementedException();
    }

    public <P extends IBaseParameters> MethodOutcome invoke(String name, P parameters, Map<String, String> headers) {
        throw new NotImplementedException();
    }

    public <R extends IBaseResource, P extends IBaseParameters, T extends IBaseResource> R invoke(Class<T> resourceType, String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        throw new NotImplementedException();
    }

    public <P extends IBaseParameters, T extends IBaseResource> MethodOutcome invoke(Class<T> resourceType, String name, P parameters, Map<String, String> headers) {
        throw new NotImplementedException();
    }

    public <R extends IBaseResource, P extends IBaseParameters, I extends IIdType> R invoke(I id, String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        throw new NotImplementedException();
    }

    public <P extends IBaseParameters, I extends IIdType> MethodOutcome invoke(I id, String name, P parameters, Map<String, String> headers) {
        throw new NotImplementedException();
    }

    public <B extends IBaseBundle, P extends IBaseParameters> B history(P parameters, Class<B> returnType, Map<String, String> headers) {
        throw new NotImplementedException("The history interaction is not currently supported");
    }

    public <B extends IBaseBundle, P extends IBaseParameters, T extends IBaseResource> B history(Class<T> resourceType, P parameters, Class<B> returnType, Map<String, String> headers) {
        throw new NotImplementedException("The history interaction is not currently supported");
    }

    public <B extends IBaseBundle, P extends IBaseParameters, I extends IIdType> B history(I id, P parameters, Class<B> returnType, Map<String, String> headers) {
        throw new NotImplementedException("The history interaction is not currently supported");
    }

    public FhirContext fhirContext() {
        return this.context;
    }

    private static /* synthetic */ Map lambda$search$5(String r) {
        return new HashMap();
    }
}

