/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.search;

import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Searches {
    public static final Map<String, List<IQueryParameterType>> ALL = Collections.emptyMap();

    private Searches() {
    }

    public static SearchBuilder builder() {
        return new SearchBuilder();
    }

    public static Map<String, List<IQueryParameterType>> byCanonical(String canonical) {
        if (canonical.contains("|")) {
            String[] split = canonical.split("|");
            return Searches.byUrlAndVersion(split[0], split[1]);
        }
        return Searches.byUrl(canonical);
    }

    public static Map<String, List<IQueryParameterType>> byCodeAndSystem(String code, String system) {
        return Searches.builder().withTokenParam("code", code, system).build();
    }

    public static Map<String, List<IQueryParameterType>> byUrl(String url) {
        return Searches.builder().withUriParam("url", url).build();
    }

    public static Map<String, List<IQueryParameterType>> byUrlAndVersion(String url, String version) {
        return Searches.builder().withUriParam("url", url).withTokenParam("version", version).build();
    }

    public static Map<String, List<IQueryParameterType>> byName(String name) {
        return Searches.builder().withStringParam("name", name).build();
    }

    public static Map<String, List<IQueryParameterType>> byNameAndVersion(String name, String version) {
        if (version == null || version.isEmpty()) {
            return Searches.builder().withStringParam("name", name).build();
        }
        return Searches.builder().withStringParam("name", name).withTokenParam("version", version).build();
    }

    public static class SearchBuilder {
        private Map<String, List<IQueryParameterType>> values;

        public Map<String, List<IQueryParameterType>> build() {
            return this.values;
        }

        public SearchBuilder withStringParam(String name, String value) {
            if (this.values == null) {
                this.values = new HashMap<String, List<IQueryParameterType>>();
            }
            this.values.put(name, Collections.singletonList(new StringParam(value)));
            return this;
        }

        public SearchBuilder withTokenParam(String name, String value) {
            if (this.values == null) {
                this.values = new HashMap<String, List<IQueryParameterType>>();
            }
            this.values.put(name, Collections.singletonList(new TokenParam(value)));
            return this;
        }

        public SearchBuilder withTokenParam(String name, String value, String system) {
            if (this.values == null) {
                this.values = new HashMap<String, List<IQueryParameterType>>();
            }
            this.values.put(name, Collections.singletonList(new TokenParam(system, value)));
            return this;
        }

        public SearchBuilder withUriParam(String name, String value) {
            if (this.values == null) {
                this.values = new HashMap<String, List<IQueryParameterType>>();
            }
            this.values.put(name, Collections.singletonList(new UriParam(value)));
            return this;
        }

        SearchBuilder withTokenParam(String name, String value, String ... values) {
            if (this.values == null) {
                this.values = new HashMap<String, List<IQueryParameterType>>();
            }
            ArrayList<TokenParam> params = new ArrayList<TokenParam>(1 + values.length);
            params.add(new TokenParam(value));
            for (String v : values) {
                params.add(new TokenParam(v));
            }
            this.values.put(name, params);
            return this;
        }
    }
}

