/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.builder;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.opencds.cqf.fhir.utility.FhirVersions;
import org.opencds.cqf.fhir.utility.Resources;
import org.opencds.cqf.fhir.utility.builder.CodeableConceptSettings;

public abstract class BackboneElementBuilder<SELF extends BackboneElementBuilder<SELF, T>, T extends IBaseBackboneElement> {
    private final Class<T> myResourceClass;
    private String myId = UUID.randomUUID().toString();
    private List<Pair<String, CodeableConceptSettings>> myExtension;
    private List<Pair<String, CodeableConceptSettings>> myModifierExtension;

    protected BackboneElementBuilder(Class<T> theResourceClass) {
        Preconditions.checkNotNull(theResourceClass);
        this.myResourceClass = theResourceClass;
    }

    protected BackboneElementBuilder(Class<T> theResourceClass, String theId) {
        this(theResourceClass);
        Preconditions.checkNotNull((Object)theId);
        this.myId = theId;
    }

    public T build() {
        T backboneElement = Resources.newBackboneElement(this.myResourceClass);
        switch (FhirVersions.forClass(this.myResourceClass)) {
            case DSTU3: {
                this.initializeDstu3(backboneElement);
                break;
            }
            case R4: {
                this.initializeR4(backboneElement);
                break;
            }
            case R5: {
                this.initializeR5(backboneElement);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("ResourceBuilder.initializeResource does not support FHIR version %s", FhirVersions.forClass(this.myResourceClass).getFhirVersionString()));
            }
        }
        return backboneElement;
    }

    private void addExtension(Pair<String, CodeableConceptSettings> theExtension) {
        if (this.myExtension == null) {
            this.myExtension = new ArrayList<Pair<String, CodeableConceptSettings>>();
        }
        this.myExtension.add(theExtension);
    }

    private List<Pair<String, CodeableConceptSettings>> getExtensions() {
        if (this.myExtension == null) {
            return Collections.emptyList();
        }
        return this.myExtension;
    }

    protected String getId() {
        return this.myId;
    }

    private void addModifierExtension(Pair<String, CodeableConceptSettings> theModifierExtension) {
        if (this.myModifierExtension == null) {
            this.myModifierExtension = new ArrayList<Pair<String, CodeableConceptSettings>>();
        }
        this.myModifierExtension.add(theModifierExtension);
    }

    private List<Pair<String, CodeableConceptSettings>> getModifierExtensions() {
        if (this.myModifierExtension == null) {
            return Collections.emptyList();
        }
        return this.myModifierExtension;
    }

    public SELF withId(String theId) {
        Preconditions.checkNotNull((Object)theId);
        this.myId = theId;
        return this.self();
    }

    public SELF withExtension(Pair<String, CodeableConceptSettings> theExtension) {
        Preconditions.checkNotNull(theExtension);
        this.addExtension(theExtension);
        return this.self();
    }

    public SELF withModifierExtension(Pair<String, CodeableConceptSettings> theModifierExtension) {
        Preconditions.checkNotNull(theModifierExtension);
        this.addModifierExtension(theModifierExtension);
        return this.self();
    }

    protected SELF self() {
        return (SELF)this;
    }

    protected void initializeDstu3(T theResource) {
        this.getExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept = new org.hl7.fhir.dstu3.model.CodeableConcept().addCoding(new Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension extension = theResource.addExtension();
            extension.setUrl((String)extensionSetting.getKey());
            extension.setValue((IBaseDatatype)codeableConcept);
        }));
        this.getModifierExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept = new org.hl7.fhir.dstu3.model.CodeableConcept().addCoding(new Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension modifierExtension = theResource.addModifierExtension();
            modifierExtension.setUrl((String)extensionSetting.getKey());
            modifierExtension.setValue((IBaseDatatype)codeableConcept);
        }));
    }

    protected void initializeR4(T theResource) {
        this.getExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            CodeableConcept codeableConcept = new CodeableConcept().addCoding(new org.hl7.fhir.r4.model.Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension extension = theResource.addExtension();
            extension.setUrl((String)extensionSetting.getKey());
            extension.setValue((IBaseDatatype)codeableConcept);
        }));
        this.getModifierExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            CodeableConcept codeableConcept = new CodeableConcept().addCoding(new org.hl7.fhir.r4.model.Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension modifierExtension = theResource.addModifierExtension();
            modifierExtension.setUrl((String)extensionSetting.getKey());
            modifierExtension.setValue((IBaseDatatype)codeableConcept);
        }));
    }

    protected void initializeR5(T theResource) {
        this.getExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            org.hl7.fhir.r5.model.CodeableConcept codeableConcept = new org.hl7.fhir.r5.model.CodeableConcept().addCoding(new org.hl7.fhir.r5.model.Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension extension = theResource.addExtension();
            extension.setUrl((String)extensionSetting.getKey());
            extension.setValue((IBaseDatatype)codeableConcept);
        }));
        this.getModifierExtensions().forEach(extensionSetting -> ((CodeableConceptSettings)extensionSetting.getValue()).getCodingSettings().forEach(coding -> {
            org.hl7.fhir.r5.model.CodeableConcept codeableConcept = new org.hl7.fhir.r5.model.CodeableConcept().addCoding(new org.hl7.fhir.r5.model.Coding().setSystem(coding.getSystem()).setCode(coding.getCode()).setDisplay(coding.getDisplay()));
            IBaseExtension modifierExtension = theResource.addModifierExtension();
            modifierExtension.setUrl((String)extensionSetting.getKey());
            modifierExtension.setValue((IBaseDatatype)codeableConcept);
        }));
    }
}

