/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.builder;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Date;
import org.hl7.fhir.dstu3.model.Composition;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Enumerations;
import org.opencds.cqf.fhir.utility.builder.CodeableConceptSettings;
import org.opencds.cqf.fhir.utility.builder.CodingSettings;
import org.opencds.cqf.fhir.utility.builder.DomainResourceBuilder;

public class CompositionBuilder<T extends IDomainResource>
extends DomainResourceBuilder<CompositionBuilder<T>, T> {
    private String myStatus;
    private String myTitle;
    private CodeableConceptSettings myType;
    private String mySubject;
    private String myAuthor;
    private String myCustodian;
    private Date myDate = new Date();

    public CompositionBuilder(Class<T> theResourceClass) {
        super(theResourceClass);
    }

    public CompositionBuilder(Class<T> theResourceClass, String theId) {
        super(theResourceClass, theId);
    }

    public CompositionBuilder(Class<T> theResourceClass, String theId, CodeableConceptSettings theType, String theStatus, String theAuthor, String theTitle) {
        this(theResourceClass, theId);
        Preconditions.checkNotNull((Object)theType, (String)theStatus, (Object)theAuthor, (Object)theTitle);
        this.myType = theType;
        this.myStatus = theStatus;
        this.myAuthor = theAuthor;
        this.myTitle = theTitle;
    }

    public CompositionBuilder<T> withStatus(String theStatus) {
        Preconditions.checkNotNull((Object)theStatus);
        this.myStatus = theStatus;
        return this;
    }

    public CompositionBuilder<T> withTitle(String theTitle) {
        Preconditions.checkNotNull((Object)theTitle);
        this.myTitle = theTitle;
        return this;
    }

    public CompositionBuilder<T> withType(CodeableConceptSettings theType) {
        Preconditions.checkNotNull((Object)theType);
        this.myType = theType;
        return this;
    }

    public CompositionBuilder<T> withDate(Date theDate) {
        Preconditions.checkNotNull((Object)theDate);
        this.myDate = theDate;
        return this;
    }

    public CompositionBuilder<T> withSubject(String theSubject) {
        this.mySubject = CompositionBuilder.ensurePatientReference(theSubject);
        return this;
    }

    public CompositionBuilder<T> withAuthor(String theAuthor) {
        Preconditions.checkNotNull((Object)theAuthor);
        Preconditions.checkArgument((theAuthor.startsWith("Practitioner") || theAuthor.startsWith("PractitionerRole") || theAuthor.startsWith("Device") || theAuthor.startsWith("Patient") || theAuthor.startsWith("RelatedPerson") || theAuthor.startsWith("Organization") ? 1 : 0) != 0);
        this.myAuthor = theAuthor;
        return this;
    }

    public CompositionBuilder<T> withCustodian(String theCustodian) {
        this.myCustodian = CompositionBuilder.ensureOrganizationReference(theCustodian);
        return this;
    }

    @Override
    public T build() {
        Preconditions.checkNotNull((Object)this.myType, (String)this.myStatus, (Object)this.myAuthor, (Object)this.myTitle);
        Preconditions.checkArgument((!this.myType.getCodingSettings().isEmpty() && this.myType.getCodingSettings().size() == 1 ? 1 : 0) != 0);
        return (T)((IDomainResource)super.build());
    }

    private CodingSettings getTypeSetting() {
        return this.myType.getCodingSettingsArray()[0];
    }

    @Override
    protected void initializeDstu3(T theResource) {
        super.initializeDstu3(theResource);
        org.hl7.fhir.dstu3.model.Composition composition = (org.hl7.fhir.dstu3.model.Composition)theResource;
        composition.setDate(this.myDate).setIdentifier(new Identifier().setSystem((String)this.getIdentifier().getKey()).setValue((String)this.getIdentifier().getValue())).setStatus(Composition.CompositionStatus.valueOf((String)this.myStatus)).setSubject(new Reference(this.mySubject)).setTitle(this.myTitle).setType(new org.hl7.fhir.dstu3.model.CodeableConcept().addCoding(new org.hl7.fhir.dstu3.model.Coding().setSystem(this.getTypeSetting().getSystem()).setCode(this.getTypeSetting().getCode()).setDisplay(this.getTypeSetting().getDisplay()))).addAuthor(new Reference(this.myAuthor)).setCustodian(new Reference(this.myCustodian));
    }

    @Override
    protected void initializeR4(T theResource) {
        super.initializeR4(theResource);
        Composition composition = (Composition)theResource;
        composition.setDate(this.myDate).setIdentifier(new org.hl7.fhir.r4.model.Identifier().setSystem((String)this.getIdentifier().getKey()).setValue((String)this.getIdentifier().getValue())).setStatus(Composition.CompositionStatus.valueOf((String)this.myStatus)).setSubject(new org.hl7.fhir.r4.model.Reference(this.mySubject)).setTitle(this.myTitle).setType(new org.hl7.fhir.r4.model.CodeableConcept().addCoding(new org.hl7.fhir.r4.model.Coding().setSystem(this.getTypeSetting().getSystem()).setCode(this.getTypeSetting().getCode()).setDisplay(this.getTypeSetting().getDisplay()))).addAuthor(new org.hl7.fhir.r4.model.Reference(this.myAuthor)).setCustodian(new org.hl7.fhir.r4.model.Reference(this.myCustodian));
    }

    @Override
    protected void initializeR5(T theResource) {
        super.initializeR5(theResource);
        org.hl7.fhir.r5.model.Composition composition = (org.hl7.fhir.r5.model.Composition)theResource;
        ArrayList<org.hl7.fhir.r5.model.Identifier> r5Identifiers = new ArrayList<org.hl7.fhir.r5.model.Identifier>();
        org.hl7.fhir.r5.model.Identifier r5Identifier = new org.hl7.fhir.r5.model.Identifier();
        r5Identifier.setSystem((String)this.getIdentifier().getKey()).setValue((String)this.getIdentifier().getValue());
        r5Identifiers.add(r5Identifier);
        ArrayList<org.hl7.fhir.r5.model.Reference> r5References = new ArrayList<org.hl7.fhir.r5.model.Reference>();
        org.hl7.fhir.r5.model.Reference r5Reference = new org.hl7.fhir.r5.model.Reference(this.mySubject);
        r5References.add(r5Reference);
        composition.setDate(this.myDate).setIdentifier(r5Identifiers).setStatus(Enumerations.CompositionStatus.valueOf((String)this.myStatus)).setSubject(r5References).setTitle(this.myTitle).setType(new CodeableConcept().addCoding(new Coding().setSystem(this.getTypeSetting().getSystem()).setCode(this.getTypeSetting().getCode()).setDisplay(this.getTypeSetting().getDisplay()))).addAuthor(new org.hl7.fhir.r5.model.Reference(this.myAuthor)).setCustodian(new org.hl7.fhir.r5.model.Reference(this.myCustodian));
    }
}

