/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.dstu3;

import ca.uhn.fhir.model.api.IQueryParameterType;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.search.Searches;

public class SearchHelper {
    private SearchHelper() {
    }

    public static <CanonicalType extends IPrimitiveType<String>> Resource searchRepositoryByCanonical(Repository repository, CanonicalType canonical) {
        Map<String, List<IQueryParameterType>> searchParams;
        if (canonical == null) {
            return null;
        }
        String url = Canonicals.getUrl(canonical);
        String version = Canonicals.getVersion(canonical);
        Class resourceType = repository.fhirContext().getResourceDefinition(Canonicals.getResourceType(canonical)).getImplementingClass();
        Bundle searchResult = (Bundle)repository.search(Bundle.class, resourceType, searchParams = version == null ? Searches.byUrl(url) : Searches.byUrlAndVersion(url, version));
        if (!searchResult.hasEntry()) {
            throw new FHIRException(String.format("No resource of type %s found for url: %s|%s", resourceType.getSimpleName(), url, version));
        }
        return searchResult.getEntryFirstRep().getResource();
    }

    public static <T extends IBaseResource> Bundle searchRepositoryWithPaging(Repository repository, Class<T> resourceType, Map<String, List<IQueryParameterType>> searchParameters, Map<String, String> headers) {
        Bundle result = (Bundle)repository.search(Bundle.class, resourceType, searchParameters, headers);
        Bundle.BundleLinkComponent next = result.getLink("next");
        if (next != null) {
            SearchHelper.getNextPage(repository, result, next.getUrl());
        }
        return result;
    }

    private static void getNextPage(Repository repository, Bundle bundle, String nextUrl) {
        Bundle nextBundle = (Bundle)repository.link(Bundle.class, nextUrl);
        nextBundle.getEntry().forEach(arg_0 -> ((Bundle)bundle).addEntry(arg_0));
        Bundle.BundleLinkComponent next = nextBundle.getLink("next");
        if (next != null) {
            SearchHelper.getNextPage(repository, bundle, next.getUrl());
        }
    }
}

