/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.iterable;

import ca.uhn.fhir.util.bundle.BundleEntryParts;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.iterable.BundleMappingIterator;

public class BundleMappingIterable<B extends IBaseBundle, T>
implements Iterable<T> {
    private final Repository repository;
    private final B bundle;
    private final Function<BundleEntryParts, T> mapper;

    public BundleMappingIterable(Repository repository, B bundle, Function<BundleEntryParts, T> mapper) {
        this.repository = repository;
        this.bundle = bundle;
        this.mapper = mapper;
    }

    @Override
    public Iterator<T> iterator() {
        return new BundleMappingIterator<B, T>(this.repository, this.bundle, this.mapper);
    }

    public Stream<T> toStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false);
    }
}

