/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.monad;

import java.util.function.Supplier;
import org.opencds.cqf.fhir.utility.monad.Try;

public class Tries {
    private Tries() {
    }

    public static <T> Try<T> of(Exception error, T value) {
        return error != null ? Tries.ofException(error) : Tries.of(value);
    }

    public static <T> Try<T> ofException(Exception error) {
        return new Try<Object>(error, null);
    }

    public static <T> Try<T> of(T value) {
        return new Try<T>(null, value);
    }

    public static <T> Try<T> of(Supplier<T> valueSupplier) {
        try {
            return Tries.of(valueSupplier.get());
        }
        catch (Exception e) {
            return Tries.ofException(e);
        }
    }
}

