/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.r4;

import java.util.Arrays;
import java.util.List;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.ValueSet;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.r4.SearchHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageHelper {
    protected static final Logger logger = LoggerFactory.getLogger(PackageHelper.class);
    protected static final List<String> PACKABLE_RESOURCES = Arrays.asList(Enumerations.FHIRAllTypes.LIBRARY.toCode(), Enumerations.FHIRAllTypes.PLANDEFINITION.toCode(), Enumerations.FHIRAllTypes.ACTIVITYDEFINITION.toCode(), Enumerations.FHIRAllTypes.STRUCTUREDEFINITION.toCode(), Enumerations.FHIRAllTypes.CODESYSTEM.toCode(), Enumerations.FHIRAllTypes.VALUESET.toCode());

    private PackageHelper() {
    }

    protected static boolean hasRelatedArtifact(Resource theResource) {
        switch (theResource.getResourceType()) {
            case Library: {
                return ((Library)theResource).hasRelatedArtifact();
            }
            case PlanDefinition: {
                return ((PlanDefinition)theResource).hasRelatedArtifact();
            }
            case ActivityDefinition: {
                return ((ActivityDefinition)theResource).hasRelatedArtifact();
            }
        }
        return false;
    }

    protected static List<RelatedArtifact> getRelatedArtifact(Resource theResource) {
        switch (theResource.getResourceType()) {
            case Library: {
                return ((Library)theResource).getRelatedArtifact();
            }
            case PlanDefinition: {
                return ((PlanDefinition)theResource).getRelatedArtifact();
            }
            case ActivityDefinition: {
                return ((ActivityDefinition)theResource).getRelatedArtifact();
            }
        }
        return null;
    }

    protected static boolean hasUrl(Resource theResource) {
        switch (theResource.getResourceType()) {
            case Library: {
                return ((Library)theResource).hasUrl();
            }
            case PlanDefinition: {
                return ((PlanDefinition)theResource).hasUrl();
            }
            case ActivityDefinition: {
                return ((ActivityDefinition)theResource).hasUrl();
            }
            case StructureDefinition: {
                return ((StructureDefinition)theResource).hasUrl();
            }
            case ValueSet: {
                return ((ValueSet)theResource).hasUrl();
            }
            case CodeSystem: {
                return ((CodeSystem)theResource).hasUrl();
            }
            case Questionnaire: {
                return ((Questionnaire)theResource).hasUrl();
            }
        }
        return false;
    }

    protected static String getUrl(Resource theResource) {
        switch (theResource.getResourceType()) {
            case Library: {
                return ((Library)theResource).getUrl();
            }
            case PlanDefinition: {
                return ((PlanDefinition)theResource).getUrl();
            }
            case ActivityDefinition: {
                return ((ActivityDefinition)theResource).getUrl();
            }
            case StructureDefinition: {
                return ((StructureDefinition)theResource).getUrl();
            }
            case ValueSet: {
                return ((ValueSet)theResource).getUrl();
            }
            case CodeSystem: {
                return ((CodeSystem)theResource).getUrl();
            }
            case Questionnaire: {
                return ((Questionnaire)theResource).getUrl();
            }
        }
        return null;
    }

    protected static boolean hasVersion(Resource theResource) {
        switch (theResource.getResourceType()) {
            case Library: {
                return ((Library)theResource).hasVersion();
            }
            case PlanDefinition: {
                return ((PlanDefinition)theResource).hasVersion();
            }
            case ActivityDefinition: {
                return ((ActivityDefinition)theResource).hasVersion();
            }
            case StructureDefinition: {
                return ((StructureDefinition)theResource).hasVersion();
            }
            case ValueSet: {
                return ((ValueSet)theResource).hasVersion();
            }
            case CodeSystem: {
                return ((CodeSystem)theResource).hasVersion();
            }
            case Questionnaire: {
                return ((Questionnaire)theResource).hasVersion();
            }
        }
        return false;
    }

    protected static String getVersion(Resource theResource) {
        switch (theResource.getResourceType()) {
            case Library: {
                return ((Library)theResource).getVersion();
            }
            case PlanDefinition: {
                return ((PlanDefinition)theResource).getVersion();
            }
            case ActivityDefinition: {
                return ((ActivityDefinition)theResource).getVersion();
            }
            case StructureDefinition: {
                return ((StructureDefinition)theResource).getVersion();
            }
            case ValueSet: {
                return ((ValueSet)theResource).getVersion();
            }
            case CodeSystem: {
                return ((CodeSystem)theResource).getVersion();
            }
            case Questionnaire: {
                return ((Questionnaire)theResource).getVersion();
            }
        }
        return null;
    }

    public static Bundle.BundleEntryComponent createEntry(Resource theResource, boolean theIsPut) {
        String resourceType = theResource.getResourceType().toString();
        Bundle.BundleEntryComponent entry = new Bundle.BundleEntryComponent().setResource(theResource);
        Bundle.BundleEntryRequestComponent request = new Bundle.BundleEntryRequestComponent();
        if (theIsPut) {
            request.setMethod(Bundle.HTTPVerb.PUT).setUrl(resourceType + "/" + theResource.getIdPart());
        } else {
            request.setMethod(Bundle.HTTPVerb.POST).setUrl(resourceType);
            if (PackageHelper.hasUrl(theResource)) {
                String url = PackageHelper.getUrl(theResource);
                if (PackageHelper.hasVersion(theResource)) {
                    request.setIfNoneExist(String.format("url=%s&version=%s", url, PackageHelper.getVersion(theResource)));
                } else {
                    request.setIfNoneExist(String.format("url=%s", url));
                }
            }
        }
        entry.setRequest(request);
        return entry;
    }

    public static void addRelatedArtifacts(Bundle theBundle, List<RelatedArtifact> theArtifacts, Repository theRepository, boolean theIsPut) {
        for (RelatedArtifact artifact : theArtifacts) {
            if (!artifact.getType().equals((Object)RelatedArtifact.RelatedArtifactType.DEPENDSON) || !artifact.hasResourceElement()) continue;
            try {
                Resource resource;
                CanonicalType canonical = artifact.getResourceElement();
                if (!PACKABLE_RESOURCES.contains(Canonicals.getResourceType(canonical)) || (resource = SearchHelper.searchRepositoryByCanonical(theRepository, canonical)) == null || !theBundle.getEntry().stream().noneMatch(e -> e.getResource().getIdElement().equals((Object)resource.getIdElement()))) continue;
                theBundle.addEntry(PackageHelper.createEntry(resource, theIsPut));
                if (!PackageHelper.hasRelatedArtifact(resource)) continue;
                PackageHelper.addRelatedArtifacts(theBundle, PackageHelper.getRelatedArtifact(resource), theRepository, theIsPut);
            }
            catch (Exception e2) {
                logger.error(e2.getMessage(), (Throwable)e2);
            }
        }
    }
}

