/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class Canonicals {
    private Canonicals() {
    }

    public static <CanonicalType extends IPrimitiveType<String>> String getResourceType(CanonicalType theCanonicalType) {
        Preconditions.checkNotNull(theCanonicalType);
        Preconditions.checkArgument((boolean)theCanonicalType.hasValue());
        return Canonicals.getResourceType((String)theCanonicalType.getValue());
    }

    public static String getResourceType(String theCanonical) {
        Preconditions.checkNotNull((Object)theCanonical);
        if (!theCanonical.contains("/")) {
            return null;
        }
        return (theCanonical = theCanonical.replace(theCanonical.substring(theCanonical.lastIndexOf("/")), "")).contains("/") ? theCanonical.substring(theCanonical.lastIndexOf("/") + 1) : theCanonical;
    }

    public static <CanonicalType extends IPrimitiveType<String>> String getIdPart(CanonicalType theCanonicalType) {
        Preconditions.checkNotNull(theCanonicalType);
        Preconditions.checkArgument((boolean)theCanonicalType.hasValue());
        return Canonicals.getIdPart((String)theCanonicalType.getValue());
    }

    public static String getIdPart(String theCanonical) {
        Preconditions.checkNotNull((Object)theCanonical);
        if (!theCanonical.contains("/")) {
            return null;
        }
        int lastIndex = Canonicals.calculateLastIndex(theCanonical);
        return theCanonical.substring(theCanonical.lastIndexOf("/") + 1, lastIndex);
    }

    public static <CanonicalType extends IPrimitiveType<String>> String getVersion(CanonicalType theCanonicalType) {
        Preconditions.checkNotNull(theCanonicalType);
        Preconditions.checkArgument((boolean)theCanonicalType.hasValue());
        return Canonicals.getVersion((String)theCanonicalType.getValue());
    }

    public static String getVersion(String theCanonical) {
        Preconditions.checkNotNull((Object)theCanonical);
        if (!theCanonical.contains("|")) {
            return null;
        }
        int lastIndex = theCanonical.lastIndexOf("#");
        if (lastIndex == -1) {
            lastIndex = theCanonical.length();
        }
        return theCanonical.substring(theCanonical.lastIndexOf("|") + 1, lastIndex);
    }

    public static <CanonicalType extends IPrimitiveType<String>> String getUrl(CanonicalType theCanonicalType) {
        Preconditions.checkNotNull(theCanonicalType);
        Preconditions.checkArgument((boolean)theCanonicalType.hasValue());
        return Canonicals.getUrl((String)theCanonicalType.getValue());
    }

    public static String getUrl(String theCanonical) {
        Preconditions.checkNotNull((Object)theCanonical);
        if (!theCanonical.contains("/")) {
            return null;
        }
        int lastIndex = Canonicals.calculateLastIndex(theCanonical);
        return theCanonical.substring(0, lastIndex);
    }

    public static List<String> getUrls(List<String> theCanonicals) {
        Preconditions.checkNotNull(theCanonicals);
        ArrayList<String> result = new ArrayList<String>();
        theCanonicals.forEach(canonical -> result.add(Canonicals.getUrl(canonical)));
        return result;
    }

    public static <CanonicalType extends IPrimitiveType<String>> String getFragment(CanonicalType theCanonicalType) {
        Preconditions.checkNotNull(theCanonicalType);
        Preconditions.checkArgument((boolean)theCanonicalType.hasValue());
        return Canonicals.getFragment((String)theCanonicalType.getValue());
    }

    public static String getFragment(String theCanonical) {
        Preconditions.checkNotNull((Object)theCanonical);
        if (!theCanonical.contains("#")) {
            return null;
        }
        return theCanonical.substring(theCanonical.lastIndexOf("#") + 1);
    }

    public static <CanonicalType extends IPrimitiveType<String>> CanonicalParts getParts(CanonicalType theCanonicalType) {
        Preconditions.checkNotNull(theCanonicalType);
        Preconditions.checkArgument((boolean)theCanonicalType.hasValue());
        return Canonicals.getParts((String)theCanonicalType.getValue());
    }

    public static CanonicalParts getParts(String theCanonical) {
        Preconditions.checkNotNull((Object)theCanonical);
        String url = Canonicals.getUrl(theCanonical);
        String id = Canonicals.getIdPart(theCanonical);
        String resourceType = Canonicals.getResourceType(theCanonical);
        String version = Canonicals.getVersion(theCanonical);
        String fragment = Canonicals.getFragment(theCanonical);
        return new CanonicalParts(url, id, resourceType, version, fragment);
    }

    private static int calculateLastIndex(String theCanonical) {
        int lastIndexOfBar = theCanonical.lastIndexOf("|");
        int lastIndexOfHash = theCanonical.lastIndexOf("#");
        int lastIndex = theCanonical.length();
        int mul = lastIndexOfBar * lastIndexOfHash;
        if (mul > 1) {
            lastIndex = Math.min(lastIndexOfBar, lastIndexOfHash);
        } else if (mul < 0) {
            lastIndex = Math.max(lastIndexOfBar, lastIndexOfHash);
        }
        return lastIndex;
    }

    public static final class CanonicalParts {
        private final String url;
        private final String idPart;
        private final String resourceType;
        private final String version;
        private final String fragment;

        CanonicalParts(String url, String idPart, String resourceType, String version, String fragment) {
            this.url = url;
            this.idPart = idPart;
            this.resourceType = resourceType;
            this.version = version;
            this.fragment = fragment;
        }

        public String url() {
            return this.url;
        }

        public String idPart() {
            return this.idPart;
        }

        public String resourceType() {
            return this.resourceType;
        }

        public String version() {
            return this.version;
        }

        public String fragment() {
            return this.fragment;
        }
    }
}

