/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.util.ParametersUtil;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class Parameters {
    private Parameters() {
    }

    private static BaseRuntimeChildDefinition getParameterChild(FhirContext fhirContext) {
        return fhirContext.getResourceDefinition("Parameters").getChildByName("parameter");
    }

    private static BaseRuntimeElementDefinition<?> getParameterElement(FhirContext fhirContext) {
        return Parameters.getParameterChild(fhirContext).getChildByName("parameter");
    }

    private static BaseRuntimeChildDefinition.IMutator getValueMutator(FhirContext fhirContext) {
        return Parameters.getParameterElement(fhirContext).getChildByName("value[x]").getMutator();
    }

    private static void validateNameAndValue(String name, Object value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
    }

    public static IBaseParameters newParameters(FhirContext fhirContext, IIdType theId, IBase ... parts) {
        Preconditions.checkNotNull((Object)theId);
        IBaseParameters newParameters = ParametersUtil.newInstance((FhirContext)fhirContext);
        newParameters.setId(theId);
        BaseRuntimeChildDefinition.IMutator mutator = Parameters.getParameterChild(fhirContext).getMutator();
        for (IBase part : parts) {
            mutator.addValue((IBase)newParameters, part);
        }
        return newParameters;
    }

    public static IBaseParameters newParameters(FhirContext fhirContext, String theId, IBase ... parts) {
        Preconditions.checkNotNull((Object)theId);
        IIdType id = (IIdType)Objects.requireNonNull(fhirContext.getElementDefinition("id")).newInstance();
        id.setValue(theId);
        return Parameters.newParameters(fhirContext, id, parts);
    }

    public static IBaseParameters newParameters(FhirContext fhirContext, IBase ... parts) {
        IBaseParameters newParameters = ParametersUtil.newInstance((FhirContext)fhirContext);
        BaseRuntimeChildDefinition.IMutator mutator = Parameters.getParameterChild(fhirContext).getMutator();
        for (IBase part : parts) {
            mutator.addValue((IBase)newParameters, part);
        }
        return newParameters;
    }

    public static IBase newPart(FhirContext fhirContext, String name, IBase ... parts) {
        Preconditions.checkNotNull((Object)name);
        BaseRuntimeChildDefinition.IMutator nameMutator = Parameters.getParameterElement(fhirContext).getChildByName("name").getMutator();
        BaseRuntimeChildDefinition.IMutator partMutator = Parameters.getParameterElement(fhirContext).getChildByName("part").getMutator();
        IBase parameterBase = Parameters.getParameterElement(fhirContext).newInstance();
        IBase theName = Objects.requireNonNull(fhirContext.getElementDefinition("string")).newInstance((Object)name);
        nameMutator.setValue(parameterBase, theName);
        for (IBase part : parts) {
            partMutator.addValue(parameterBase, part);
        }
        return parameterBase;
    }

    public static <T extends IBaseDatatype> IBase newPart(FhirContext fhirContext, Class<T> type, String name, Object value, IBase ... parts) {
        Parameters.validateNameAndValue(name, value);
        IBase newPpc = Parameters.newPart(fhirContext, name, parts);
        IBase typeValue = Objects.requireNonNull(fhirContext.getElementDefinition(type)).newInstance(value);
        Parameters.getValueMutator(fhirContext).setValue(newPpc, typeValue);
        return newPpc;
    }

    public static IBase newPart(FhirContext fhirContext, String typeName, String name, Object value, IBase ... parts) {
        Parameters.validateNameAndValue(name, value);
        IBase newPpc = Parameters.newPart(fhirContext, name, parts);
        IBase typeValue = Objects.requireNonNull(fhirContext.getElementDefinition(typeName)).newInstance((Object)value.toString());
        Parameters.getValueMutator(fhirContext).setValue(newPpc, typeValue);
        return newPpc;
    }

    public static IBase newPart(FhirContext fhirContext, String name, IBaseResource value, IBase ... parts) {
        Parameters.validateNameAndValue(name, value);
        IBase newPpc = Parameters.newPart(fhirContext, name, parts);
        Parameters.getParameterElement(fhirContext).getChildByName("resource").getMutator().setValue(newPpc, (IBase)value);
        return newPpc;
    }

    public static Optional<String> getSingularStringPart(FhirContext fhirContext, IBaseResource parameters, String name) {
        Preconditions.checkNotNull((Object)parameters);
        Preconditions.checkNotNull((Object)name);
        return ParametersUtil.getNamedParameterValueAsString((FhirContext)fhirContext, (IBaseParameters)((IBaseParameters)parameters), (String)name);
    }

    public static List<IBase> getPartsByName(FhirContext fhirContext, IBaseResource parameters, String name) {
        Preconditions.checkNotNull((Object)parameters);
        Preconditions.checkNotNull((Object)name);
        return ParametersUtil.getNamedParameters((FhirContext)fhirContext, (IBaseResource)parameters, (String)name);
    }

    public static IBase newBase64BinaryPart(FhirContext fhirContext, String name, String value, IBase ... parts) {
        return Parameters.newPart(fhirContext, "base64binary", name, (Object)value, parts);
    }

    public static IBase newBooleanPart(FhirContext fhirContext, String name, boolean value, IBase ... parts) {
        return Parameters.newPart(fhirContext, "boolean", name, (Object)value, parts);
    }

    public static IBase newCanonicalPart(FhirContext fhirContext, String name, String value, IBase ... parts) {
        return Parameters.newPart(fhirContext, "canonical", name, (Object)value, parts);
    }

    public static IBase newCodePart(FhirContext fhirContext, String name, String value, IBase ... parts) {
        return Parameters.newPart(fhirContext, "code", name, (Object)value, parts);
    }

    public static IBase newDatePart(FhirContext fhirContext, String name, String value, IBase ... parts) {
        return Parameters.newPart(fhirContext, "date", name, (Object)value, parts);
    }

    public static IBase newDateTimePart(FhirContext fhirContext, String name, String value, IBase ... parts) {
        return Parameters.newPart(fhirContext, "datetime", name, (Object)value, parts);
    }

    public static IBase newDecimalPart(FhirContext fhirContext, String name, double value, IBase ... parts) {
        return Parameters.newPart(fhirContext, "decimal", name, (Object)value, parts);
    }

    public static IBase newIdPart(FhirContext fhirContext, String name, String value, IBase ... parts) {
        return Parameters.newPart(fhirContext, "id", name, (Object)value, parts);
    }

    public static IBase newInstantPart(FhirContext fhirContext, String name, String value, IBase ... parts) {
        return Parameters.newPart(fhirContext, "instant", name, (Object)value, parts);
    }

    public static IBase newIntegerPart(FhirContext fhirContext, String name, int value, IBase ... parts) {
        return Parameters.newPart(fhirContext, "integer", name, (Object)value, parts);
    }

    public static IBase newInteger64Part(FhirContext fhirContext, String name, long value, IBase ... parts) {
        return Parameters.newPart(fhirContext, "integer64", name, (Object)value, parts);
    }

    public static IBase newMarkdownPart(FhirContext fhirContext, String name, String value, IBase ... parts) {
        return Parameters.newPart(fhirContext, "markdown", name, (Object)value, parts);
    }

    public static IBase newOidPart(FhirContext fhirContext, String name, String value, IBase ... parts) {
        return Parameters.newPart(fhirContext, "oid", name, (Object)value, parts);
    }

    public static IBase newPositiveIntPart(FhirContext fhirContext, String name, int value, IBase ... parts) {
        return Parameters.newPart(fhirContext, "positiveint", name, (Object)value, parts);
    }

    public static IBase newStringPart(FhirContext fhirContext, String name, String value, IBase ... parts) {
        return Parameters.newPart(fhirContext, "string", name, (Object)value, parts);
    }

    public static IBase newTimePart(FhirContext fhirContext, String name, String value, IBase ... parts) {
        return Parameters.newPart(fhirContext, "time", name, (Object)value, parts);
    }

    public static IBase newUnsignedIntPart(FhirContext fhirContext, String name, int value, IBase ... parts) {
        return Parameters.newPart(fhirContext, "unsignedint", name, (Object)value, parts);
    }

    public static IBase newUriPart(FhirContext fhirContext, String name, String value, IBase ... parts) {
        return Parameters.newPart(fhirContext, "uri", name, (Object)value, parts);
    }

    public static IBase newUrlPart(FhirContext fhirContext, String name, String value, IBase ... parts) {
        return Parameters.newPart(fhirContext, "url", name, (Object)value, parts);
    }

    public static IBase newUuidPart(FhirContext fhirContext, String name, String value, IBase ... parts) {
        return Parameters.newPart(fhirContext, "uuid", name, (Object)value, parts);
    }
}

