/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.fhir.utility.FhirVersions;

public class Reflections {
    private Reflections() {
    }

    public static <BaseType extends IBase> BaseRuntimeChildDefinition.IAccessor getAccessor(Class<? extends BaseType> theBaseTypeClass, String theChildName) {
        Preconditions.checkNotNull(theBaseTypeClass);
        Preconditions.checkNotNull((Object)theChildName);
        FhirContext fhirContext = FhirContext.forCached((FhirVersionEnum)FhirVersions.forClass(theBaseTypeClass));
        if (theBaseTypeClass.isInstance(IBaseResource.class)) {
            Class<IBaseResource> theIBaseResourceClass = theBaseTypeClass.asSubclass(IBaseResource.class);
            RuntimeResourceDefinition resourceDefinition = fhirContext.getResourceDefinition(theIBaseResourceClass);
            return resourceDefinition.getChildByName(theChildName).getAccessor();
        }
        BaseRuntimeElementDefinition elementDefinition = fhirContext.getElementDefinition(theBaseTypeClass);
        return elementDefinition.getChildByName(theChildName).getAccessor();
    }

    public static <BaseType extends IBase, ReturnType> Function<BaseType, ReturnType> getPrimitiveFunction(Class<? extends BaseType> theBaseTypeClass, String theChildName) {
        Preconditions.checkNotNull(theBaseTypeClass);
        Preconditions.checkNotNull((Object)theChildName);
        BaseRuntimeChildDefinition.IAccessor accessor = Reflections.getAccessor(theBaseTypeClass, theChildName);
        return r -> {
            Optional value = accessor.getFirstValueOrNull(r);
            if (!value.isPresent()) {
                return null;
            }
            Object x = ((IPrimitiveType)value.get()).getValue();
            return x;
        };
    }

    public static <BaseType extends IBase, ReturnType extends List<? extends IBase>> Function<BaseType, ReturnType> getFunction(Class<? extends BaseType> theBaseTypeClass, String theChildName) {
        Preconditions.checkNotNull(theBaseTypeClass);
        Preconditions.checkNotNull((Object)theChildName);
        BaseRuntimeChildDefinition.IAccessor accessor = Reflections.getAccessor(theBaseTypeClass, theChildName);
        return r -> {
            List x = accessor.getValues(r);
            return x;
        };
    }

    public static <BaseType extends IBase> Function<BaseType, String> getVersionFunction(Class<? extends BaseType> theBaseTypeClass) {
        Preconditions.checkNotNull(theBaseTypeClass);
        return Reflections.getPrimitiveFunction(theBaseTypeClass, "version");
    }

    public static <BaseType extends IBase> Function<BaseType, String> getUrlFunction(Class<? extends BaseType> theBaseTypeClass) {
        Preconditions.checkNotNull(theBaseTypeClass);
        return Reflections.getPrimitiveFunction(theBaseTypeClass, "url");
    }

    public static <BaseType extends IBase> Function<BaseType, String> getNameFunction(Class<? extends BaseType> theBaseTypeClass) {
        Preconditions.checkNotNull(theBaseTypeClass);
        return Reflections.getPrimitiveFunction(theBaseTypeClass, "name");
    }
}

