/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import com.google.common.base.Preconditions;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.utility.Ids;

public class Resources {
    private Resources() {
    }

    public static <T extends IBaseResource, I extends IIdType> T newResource(Class<T> theResourceClass, String theIdPart) {
        Preconditions.checkNotNull(theResourceClass);
        Preconditions.checkNotNull((Object)theIdPart);
        Preconditions.checkArgument((!theIdPart.contains("/") ? 1 : 0) != 0, (Object)"theIdPart must be a simple id. Do not include resourceType or history");
        T resource = Resources.newResource(theResourceClass);
        Object id = Ids.newId(theResourceClass, theIdPart);
        resource.setId(id);
        return resource;
    }

    public static <T extends IBaseResource> T newResource(Class<T> theResourceClass) {
        Preconditions.checkNotNull(theResourceClass);
        IBaseResource resource = null;
        try {
            resource = (IBaseResource)theResourceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("theResourceClass must be a type with an empty default constructor to use this function");
        }
        return (T)resource;
    }

    public static <T extends IBaseBackboneElement> T newBackboneElement(Class<T> theBackboneElementClass) {
        Preconditions.checkNotNull(theBackboneElementClass);
        IBaseBackboneElement backboneElement = null;
        try {
            backboneElement = (IBaseBackboneElement)theBackboneElementClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("theBackboneElementClass must be a type with an empty default constructor to use this function");
        }
        return (T)backboneElement;
    }
}

