/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Function;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class Versions {
    private Versions() {
    }

    public static int compareVersions(String version1, String version2) {
        if (version1 == null && version2 == null) {
            return 0;
        }
        if (version1 != null && version2 == null) {
            return -1;
        }
        if (version1 == null) {
            return 1;
        }
        String[] string1Vals = version1.split("\\.");
        String[] string2Vals = version2.split("\\.");
        int length = Math.max(string1Vals.length, string2Vals.length);
        for (int i = 0; i < length; ++i) {
            Integer v1 = i < string1Vals.length ? Integer.parseInt(string1Vals[i]) : 0;
            Integer v2 = i < string2Vals.length ? Integer.parseInt(string2Vals[i]) : 0;
            if (v1 > v2) {
                return 1;
            }
            if (v1 >= v2) continue;
            return -1;
        }
        return 0;
    }

    public static <ResourceType extends IBaseResource> ResourceType selectByVersion(List<ResourceType> theResources, String theVersion, Function<ResourceType, String> theGetVersion) {
        Preconditions.checkNotNull(theResources);
        Preconditions.checkNotNull(theGetVersion);
        IBaseResource library = null;
        IBaseResource maxVersion = null;
        for (IBaseResource l : theResources) {
            String currentVersion = theGetVersion.apply(l);
            if (theVersion == null && currentVersion == null || theVersion != null && theVersion.equals(currentVersion)) {
                library = l;
            }
            if (maxVersion != null && Versions.compareVersions(currentVersion, theGetVersion.apply(maxVersion)) < 0) continue;
            maxVersion = l;
        }
        if ((theVersion == null || library == null) && maxVersion != null) {
            return (ResourceType)maxVersion;
        }
        return (ResourceType)library;
    }
}

