/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.builder;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.dstu3.model.Composition;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.Narrative;
import org.opencds.cqf.fhir.utility.builder.BackboneElementBuilder;
import org.opencds.cqf.fhir.utility.builder.NarrativeSettings;

public class CompositionSectionComponentBuilder<T extends IBaseBackboneElement>
extends BackboneElementBuilder<CompositionSectionComponentBuilder<T>, T> {
    private String myTitle;
    private String myFocus;
    private List<String> myEntry;
    private NarrativeSettings myText;

    public CompositionSectionComponentBuilder(Class<T> theResourceClass) {
        super(theResourceClass);
    }

    public CompositionSectionComponentBuilder(Class<T> theResourceClass, String theId) {
        super(theResourceClass, theId);
    }

    public CompositionSectionComponentBuilder(Class<T> theResourceClass, String theId, String theFocus, String theEntry) {
        this(theResourceClass, theId);
        Preconditions.checkNotNull((Object)theFocus, (Object)theEntry);
        this.myFocus = theFocus;
        this.addEntry(theEntry);
    }

    private void addEntry(String entry) {
        if (this.myEntry == null) {
            this.myEntry = new ArrayList<String>();
        }
        this.myEntry.add(entry);
    }

    private List<String> getEntries() {
        if (this.myEntry == null) {
            return Collections.emptyList();
        }
        return this.myEntry;
    }

    public CompositionSectionComponentBuilder<T> withTitle(String theTitle) {
        Preconditions.checkNotNull((Object)theTitle);
        this.myTitle = theTitle;
        return this;
    }

    public CompositionSectionComponentBuilder<T> withFocus(String theFocus) {
        Preconditions.checkNotNull((Object)theFocus);
        this.myFocus = theFocus;
        return this;
    }

    public CompositionSectionComponentBuilder<T> withEntry(String theEntry) {
        Preconditions.checkNotNull((Object)theEntry);
        this.addEntry(theEntry);
        return this;
    }

    public CompositionSectionComponentBuilder<T> withText(NarrativeSettings theText) {
        Preconditions.checkNotNull((Object)theText);
        this.myText = theText;
        return this;
    }

    @Override
    public T build() {
        Preconditions.checkNotNull((Object)this.myFocus, this.myEntry);
        Preconditions.checkArgument((!this.myEntry.isEmpty() ? 1 : 0) != 0);
        return super.build();
    }

    @Override
    protected void initializeDstu3(T theResource) {
        super.initializeDstu3(theResource);
        Composition.SectionComponent section = (Composition.SectionComponent)theResource;
        section.setTitle(this.myTitle).setId(this.getId());
        this.getEntries().forEach(entry -> section.addEntry(new org.hl7.fhir.dstu3.model.Reference(entry)));
        if (this.myText != null) {
            org.hl7.fhir.dstu3.model.Narrative narrative = new org.hl7.fhir.dstu3.model.Narrative();
            narrative.setStatusAsString(this.myText.getStatus());
            narrative.setDivAsString(this.myText.getText());
            section.setText(narrative);
        }
    }

    @Override
    protected void initializeR4(T theResource) {
        super.initializeR4(theResource);
        Composition.SectionComponent section = (Composition.SectionComponent)theResource;
        section.setFocus(new Reference(this.myFocus)).setTitle(this.myTitle).setId(this.getId());
        this.getEntries().forEach(entry -> section.addEntry(new Reference(entry)));
        if (this.myText != null) {
            org.hl7.fhir.r4.model.Narrative narrative = new org.hl7.fhir.r4.model.Narrative();
            narrative.setStatusAsString(this.myText.getStatus());
            narrative.setDivAsString(this.myText.getText());
            section.setText(narrative);
        }
    }

    @Override
    protected void initializeR5(T theResource) {
        super.initializeR5(theResource);
        Composition.SectionComponent section = (Composition.SectionComponent)theResource;
        section.setFocus(new org.hl7.fhir.r5.model.Reference(this.myFocus)).setTitle(this.myTitle).setId(this.getId());
        this.getEntries().forEach(entry -> section.addEntry(new org.hl7.fhir.r5.model.Reference(entry)));
        if (this.myText != null) {
            Narrative narrative = new Narrative();
            narrative.setStatusAsString(this.myText.getStatus());
            narrative.setDivAsString(this.myText.getText());
            section.setText(narrative);
        }
    }
}

