/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.client;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.api.ServerValidationModeEnum;
import ca.uhn.fhir.rest.client.interceptor.BasicAuthInterceptor;
import ca.uhn.fhir.rest.client.interceptor.BearerTokenAuthInterceptor;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Endpoint;
import org.opencds.cqf.fhir.utility.client.HeaderInjectionInterceptor;

public class Clients {
    private Clients() {
    }

    public static IGenericClient forUrl(FhirVersionEnum theFhirVersionEnum, String theUrl) {
        Preconditions.checkNotNull((Object)theFhirVersionEnum);
        Preconditions.checkNotNull((Object)theUrl);
        return Clients.forUrl(FhirContext.forCached((FhirVersionEnum)theFhirVersionEnum), theUrl);
    }

    public static IGenericClient forUrl(FhirContext theFhirContext, String theUrl) {
        Preconditions.checkNotNull((Object)theFhirContext);
        Preconditions.checkNotNull((Object)theUrl);
        return Clients.forUrl(theFhirContext, theUrl, ServerValidationModeEnum.NEVER);
    }

    public static IGenericClient forUrl(FhirVersionEnum theFhirVersionEnum, String theUrl, ServerValidationModeEnum theServerValidationModeEnum) {
        Preconditions.checkNotNull((Object)theFhirVersionEnum, (Object)"theFhirVersionEnum is required");
        Preconditions.checkNotNull((Object)theUrl, (Object)"theUrl is required");
        Preconditions.checkNotNull((Object)theServerValidationModeEnum, (Object)"theServerValidationModeEnum is required");
        return Clients.forUrl(FhirContext.forCached((FhirVersionEnum)theFhirVersionEnum), theUrl, theServerValidationModeEnum);
    }

    public static IGenericClient forUrl(FhirContext theFhirContext, String theUrl, ServerValidationModeEnum theServerValidationModeEnum) {
        Preconditions.checkNotNull((Object)theFhirContext);
        Preconditions.checkNotNull((Object)theUrl);
        Preconditions.checkNotNull((Object)theServerValidationModeEnum, (Object)"theServerValidationModeEnum is required");
        theFhirContext.getRestfulClientFactory().setServerValidationMode(theServerValidationModeEnum);
        return theFhirContext.newRestfulGenericClient(theUrl);
    }

    public static IGenericClient forEndpoint(org.hl7.fhir.dstu3.model.Endpoint theEndpoint) {
        Preconditions.checkNotNull((Object)theEndpoint);
        return Clients.forEndpoint(FhirContext.forDstu3Cached(), theEndpoint);
    }

    public static IGenericClient forEndpoint(FhirContext theFhirContext, org.hl7.fhir.dstu3.model.Endpoint theEndpoint) {
        Preconditions.checkNotNull((Object)theFhirContext);
        Preconditions.checkNotNull((Object)theEndpoint);
        IGenericClient client = Clients.forUrl(theFhirContext, theEndpoint.getAddress());
        if (theEndpoint.hasHeader()) {
            List<String> headerList = theEndpoint.getHeader().stream().map(headerString -> headerString.asStringValue()).collect(Collectors.toList());
            Clients.registerHeaders(client, headerList);
        }
        return client;
    }

    public static IGenericClient forEndpoint(Endpoint theEndpoint) {
        Preconditions.checkNotNull((Object)theEndpoint);
        return Clients.forEndpoint(FhirContext.forR4Cached(), theEndpoint);
    }

    public static IGenericClient forEndpoint(FhirContext theFhirContext, Endpoint theEndpoint) {
        Preconditions.checkNotNull((Object)theFhirContext);
        Preconditions.checkNotNull((Object)theEndpoint);
        IGenericClient client = Clients.forUrl(theFhirContext, theEndpoint.getAddress());
        if (theEndpoint.hasHeader()) {
            List<String> headerList = theEndpoint.getHeader().stream().map(headerString -> headerString.asStringValue()).collect(Collectors.toList());
            Clients.registerHeaders(client, headerList);
        }
        return client;
    }

    public static IGenericClient forEndpoint(org.hl7.fhir.r5.model.Endpoint theEndpoint) {
        Preconditions.checkNotNull((Object)theEndpoint, (Object)"theEndpoint is required");
        return Clients.forEndpoint(FhirContext.forR4Cached(), theEndpoint);
    }

    public static IGenericClient forEndpoint(FhirContext theFhirContext, org.hl7.fhir.r5.model.Endpoint theEndpoint) {
        Preconditions.checkNotNull((Object)theFhirContext);
        Preconditions.checkNotNull((Object)theEndpoint);
        IGenericClient client = Clients.forUrl(theFhirContext, theEndpoint.getAddress());
        if (theEndpoint.hasHeader()) {
            List<String> headerList = theEndpoint.getHeader().stream().map(headerString -> headerString.asStringValue()).collect(Collectors.toList());
            Clients.registerHeaders(client, headerList);
        }
        return client;
    }

    public static void registerHeaders(IGenericClient theClient, String ... theHeaders) {
        Preconditions.checkNotNull((Object)theClient);
        Clients.registerHeaders(theClient, Arrays.asList(theHeaders));
    }

    public static void registerHeaders(IGenericClient theClient, List<String> theHeaderList) {
        Preconditions.checkNotNull((Object)theClient);
        Preconditions.checkNotNull(theHeaderList);
        Map<String, String> headerMap = Clients.setupHeaderMap(theHeaderList);
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            HeaderInjectionInterceptor headInterceptor = new HeaderInjectionInterceptor(entry.getKey(), entry.getValue());
            theClient.registerInterceptor((Object)headInterceptor);
        }
    }

    public static void registerBasicAuth(IGenericClient theClient, String theUsername, String thePassword) {
        Preconditions.checkNotNull((Object)theClient, (Object)"theClient is required");
        if (theUsername != null) {
            BasicAuthInterceptor authInterceptor = new BasicAuthInterceptor(theUsername, thePassword);
            theClient.registerInterceptor((Object)authInterceptor);
        }
    }

    public static void registerBearerTokenAuth(IGenericClient theClient, String theToken) {
        Preconditions.checkNotNull((Object)theClient, (Object)"theClient is required");
        if (theToken != null) {
            BearerTokenAuthInterceptor authInterceptor = new BearerTokenAuthInterceptor(theToken);
            theClient.registerInterceptor((Object)authInterceptor);
        }
    }

    static Map<String, String> setupHeaderMap(List<String> theHeaderList) {
        Preconditions.checkNotNull(theHeaderList, (Object)"theHeaderList is required");
        HashMap<String, String> headerMap = new HashMap<String, String>();
        String leftAuth = null;
        String rightAuth = null;
        if (theHeaderList.size() < 1 || theHeaderList.isEmpty()) {
            leftAuth = null;
            rightAuth = null;
            headerMap.put(leftAuth, rightAuth);
        } else {
            for (String header : theHeaderList) {
                if (!header.contains(":")) {
                    throw new IllegalArgumentException("Endpoint header must contain \":\" .");
                }
                String[] authSplit = header.split(":");
                leftAuth = authSplit[0];
                rightAuth = authSplit[1];
                headerMap.put(leftAuth, rightAuth);
            }
        }
        return headerMap;
    }
}

