/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IClientExecutable;
import ca.uhn.fhir.rest.gclient.ICreateTyped;
import ca.uhn.fhir.rest.gclient.IDeleteTyped;
import ca.uhn.fhir.rest.gclient.IFetchConformanceTyped;
import ca.uhn.fhir.rest.gclient.IGetPageTyped;
import ca.uhn.fhir.rest.gclient.IHistoryTyped;
import ca.uhn.fhir.rest.gclient.IHistoryUntyped;
import ca.uhn.fhir.rest.gclient.IOperationUnnamed;
import ca.uhn.fhir.rest.gclient.IOperationUntypedWithInput;
import ca.uhn.fhir.rest.gclient.IPatchExecutable;
import ca.uhn.fhir.rest.gclient.IQuery;
import ca.uhn.fhir.rest.gclient.IReadExecutable;
import ca.uhn.fhir.rest.gclient.ITransactionTyped;
import ca.uhn.fhir.rest.gclient.IUpdateExecutable;
import ca.uhn.fhir.util.ParametersUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.fhir.api.Repository;

public class RestRepository
implements Repository {
    private IGenericClient client;

    public RestRepository(IGenericClient client) {
        this.client = client;
    }

    protected IGenericClient getClient() {
        return this.client;
    }

    public <T extends IBaseResource, I extends IIdType> T read(Class<T> resourceType, I id, Map<String, String> headers) {
        IReadExecutable op = this.client.read().resource(resourceType).withId(id);
        return (T)((IBaseResource)this.addHeaders(op, headers).execute());
    }

    public <T extends IBaseResource> MethodOutcome create(T resource, Map<String, String> headers) {
        ICreateTyped op = this.client.create().resource(resource);
        return (MethodOutcome)this.addHeaders(op, headers).execute();
    }

    public <I extends IIdType, P extends IBaseParameters> MethodOutcome patch(I id, P patchParameters, Map<String, String> headers) {
        IPatchExecutable op = this.client.patch().withFhirPatch(patchParameters).withId(id);
        return (MethodOutcome)this.addHeaders(op, headers).execute();
    }

    public <T extends IBaseResource> MethodOutcome update(T resource, Map<String, String> headers) {
        IUpdateExecutable op = this.client.update().resource(resource).withId(resource.getIdElement());
        return (MethodOutcome)this.addHeaders(op, headers).execute();
    }

    public <T extends IBaseResource, I extends IIdType> MethodOutcome delete(Class<T> resourceType, I id, Map<String, String> headers) {
        IDeleteTyped op = this.client.delete().resourceById(id);
        return (MethodOutcome)this.addHeaders(op, headers).execute();
    }

    public <B extends IBaseBundle, T extends IBaseResource> B search(Class<B> bundleType, Class<T> resourceType, Map<String, List<IQueryParameterType>> searchParameters, Map<String, String> headers) {
        IQuery op = this.client.search().forResource(resourceType).returnBundle(bundleType);
        if (searchParameters != null) {
            op = (IQuery)op.where(searchParameters);
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                op = (IQuery)op.withAdditionalHeader(entry.getKey(), entry.getValue());
            }
        }
        return (B)((IBaseBundle)this.addHeaders(op, headers).execute());
    }

    public <C extends IBaseConformance> C capabilities(Class<C> resourceType, Map<String, String> headers) {
        IFetchConformanceTyped op = this.client.capabilities().ofType(resourceType);
        return (C)((IBaseConformance)this.addHeaders(op, headers).execute());
    }

    public <B extends IBaseBundle> B transaction(B transaction, Map<String, String> headers) {
        ITransactionTyped op = this.client.transaction().withBundle(transaction);
        return (B)((IBaseBundle)this.addHeaders(op, headers).execute());
    }

    public <B extends IBaseBundle> B link(Class<B> bundleType, String url, Map<String, String> headers) {
        IGetPageTyped op = this.client.loadPage().byUrl(url).andReturnBundle(bundleType);
        return (B)((IBaseBundle)this.addHeaders(op, headers).execute());
    }

    public <R extends IBaseResource, P extends IBaseParameters> R invoke(String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        IOperationUntypedWithInput op = ((IOperationUnnamed)this.client.operation().onServer()).named(name).withParameters(parameters).returnResourceType(returnType);
        return (R)((IBaseResource)this.addHeaders(op, headers).execute());
    }

    public <P extends IBaseParameters> MethodOutcome invoke(String name, P parameters, Map<String, String> headers) {
        IOperationUntypedWithInput op = ((IOperationUnnamed)this.client.operation().onServer()).named(name).withParameters(parameters).returnMethodOutcome();
        return (MethodOutcome)this.addHeaders(op, headers).execute();
    }

    public <R extends IBaseResource, P extends IBaseParameters, T extends IBaseResource> R invoke(Class<T> resourceType, String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        IOperationUntypedWithInput op = ((IOperationUnnamed)this.client.operation().onType(resourceType)).named(name).withParameters(parameters).returnResourceType(returnType);
        return (R)((IBaseResource)this.addHeaders(op, headers).execute());
    }

    public <P extends IBaseParameters, T extends IBaseResource> MethodOutcome invoke(Class<T> resourceType, String name, P parameters, Map<String, String> headers) {
        IOperationUntypedWithInput op = ((IOperationUnnamed)this.client.operation().onType(resourceType)).named(name).withParameters(parameters).returnMethodOutcome();
        return (MethodOutcome)this.addHeaders(op, headers).execute();
    }

    public <R extends IBaseResource, P extends IBaseParameters, I extends IIdType> R invoke(I id, String name, P parameters, Class<R> returnType, Map<String, String> headers) {
        IOperationUntypedWithInput op = ((IOperationUnnamed)this.client.operation().onInstance(id)).named(name).withParameters(parameters).returnResourceType(returnType);
        return (R)((IBaseResource)this.addHeaders(op, headers).execute());
    }

    public <P extends IBaseParameters, I extends IIdType> MethodOutcome invoke(I id, String name, P parameters, Map<String, String> headers) {
        IOperationUntypedWithInput op = ((IOperationUnnamed)this.client.operation().onInstance(id)).named(name).withParameters(parameters).returnMethodOutcome();
        return (MethodOutcome)this.addHeaders(op, headers).execute();
    }

    public <B extends IBaseBundle, P extends IBaseParameters> B history(P parameters, Class<B> returnType, Map<String, String> headers) {
        IHistoryTyped op = ((IHistoryUntyped)this.client.history().onServer()).returnBundle(returnType);
        this.addHistoryParams(null, parameters);
        return (B)((IBaseBundle)this.addHeaders(op, headers).execute());
    }

    public <B extends IBaseBundle, P extends IBaseParameters, T extends IBaseResource> B history(Class<T> resourceType, P parameters, Class<B> returnType, Map<String, String> headers) {
        IHistoryTyped op = ((IHistoryUntyped)this.client.history().onType(resourceType)).returnBundle(returnType);
        this.addHistoryParams(null, parameters);
        return (B)((IBaseBundle)this.addHeaders(op, headers).execute());
    }

    public <B extends IBaseBundle, P extends IBaseParameters, I extends IIdType> B history(I id, P parameters, Class<B> returnType, Map<String, String> headers) {
        IHistoryTyped op = ((IHistoryUntyped)this.client.history().onInstance(id)).returnBundle(returnType);
        this.addHistoryParams(null, parameters);
        return (B)((IBaseBundle)this.addHeaders(op, headers).execute());
    }

    public FhirContext fhirContext() {
        return this.getClient().getFhirContext();
    }

    protected <B extends IBaseBundle, P extends IBaseParameters> void addHistoryParams(IHistoryTyped<B> operation, P parameters) {
        Optional since;
        FhirContext ctx = this.client.getFhirContext();
        List count = ParametersUtil.getNamedParameterValuesAsInteger((FhirContext)ctx, parameters, (String)"_count");
        if (count != null && !count.isEmpty()) {
            operation.count((Integer)count.get(0));
        }
        if ((since = ParametersUtil.getNamedParameter((FhirContext)ctx, parameters, (String)"_since")).isPresent()) {
            operation.since((IPrimitiveType)since.get());
        }
    }

    protected <T extends IClientExecutable<T, ?>> T addHeaders(T op, Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            op = op.withAdditionalHeader(entry.getKey(), entry.getValue());
        }
        return op;
    }
}

