/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.Parameters;
import org.opencds.cqf.fhir.utility.ValueSets;
import org.opencds.cqf.fhir.utility.adapter.AdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.EndpointAdapter;
import org.opencds.cqf.fhir.utility.adapter.ParametersAdapter;
import org.opencds.cqf.fhir.utility.adapter.ValueSetAdapter;
import org.opencds.cqf.fhir.utility.client.TerminologyServerClient;
import org.opencds.cqf.fhir.utility.visitor.VisitorHelper;

public class ExpandHelper {
    private final FhirContext fhirContext;
    private final TerminologyServerClient terminologyServerClient;
    public static final List<String> unsupportedParametersToRemove = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList("canonical-version")));

    public ExpandHelper(FhirContext fhirContext, TerminologyServerClient server) {
        this.fhirContext = fhirContext;
        this.terminologyServerClient = server;
    }

    private static void filterOutUnsupportedParameters(ParametersAdapter parameters) {
        List<? extends IBaseBackboneElement> paramsToSet = parameters.getParameter();
        unsupportedParametersToRemove.forEach(parameterUrl -> {
            while (parameters.getParameter((String)parameterUrl) != null) {
                paramsToSet.remove(parameters.getParameter((String)parameterUrl));
                parameters.setParameter(paramsToSet);
            }
        });
    }

    public void expandValueSet(ValueSetAdapter valueSet, ParametersAdapter expansionParameters, Optional<EndpointAdapter> terminologyEndpoint, List<ValueSetAdapter> valueSets, List<String> expandedList, Repository repository, Date expansionTimestamp) {
        if (expandedList.contains(valueSet.getUrl())) {
            return;
        }
        ExpandHelper.filterOutUnsupportedParameters(expansionParameters);
        String authoritativeSourceUrl = valueSet.getExtension().stream().filter(e -> e.getUrl().equals("http://hl7.org/fhir/StructureDefinition/valueset-authoritativeSource")).findFirst().map(url -> ((IPrimitiveType)url.getValue()).getValueAsString()).map(url -> TerminologyServerClient.getAddressBase(url, this.fhirContext)).orElse(null);
        if (terminologyEndpoint.isPresent() && (authoritativeSourceUrl == null || authoritativeSourceUrl.equals(terminologyEndpoint.get().getAddress()))) {
            try {
                ValueSetAdapter expandedValueSet = (ValueSetAdapter)AdapterFactory.createAdapterForResource(this.terminologyServerClient.expand(valueSet, terminologyEndpoint.get(), expansionParameters));
                valueSet.setExpansion(expandedValueSet.getExpansion());
            }
            catch (Exception ex) {
                throw new UnprocessableEntityException(String.format("Terminology Server expansion failed for ValueSet (%s): %s", valueSet.getId(), ex.getMessage()));
            }
        }
        if (valueSet.hasSimpleCompose()) {
            valueSet.naiveExpand();
        } else if (valueSet.hasGroupingCompose()) {
            Object expansion = valueSet.newExpansion();
            List<String> includes = valueSet.getValueSetIncludes();
            includes.forEach(reference -> {
                String[] split = reference.split("\\|");
                String url = split.length == 1 ? reference : split[0];
                String version = split.length == 1 ? null : split[1];
                ValueSetAdapter includedVS = valueSets.stream().filter(v -> v.getUrl().equals(url) && (version == null || v.getVersion().equals(version))).findFirst().orElseGet(() -> {
                    if (terminologyEndpoint.isPresent()) {
                        return this.terminologyServerClient.getResource((EndpointAdapter)terminologyEndpoint.get(), (String)reference, valueSet.get().getStructureFhirVersionEnum()).map(r -> (ValueSetAdapter)AdapterFactory.createAdapterForResource((IBaseResource)r)).orElse(null);
                    }
                    return VisitorHelper.tryGetLatestVersion(reference, repository).map(a -> (ValueSetAdapter)a).orElse(null);
                });
                if (includedVS != null) {
                    if (!expandedList.contains(url)) {
                        IBaseBackboneElement versionParam;
                        ParametersAdapter childExpParams = (ParametersAdapter)AdapterFactory.createAdapterForResource(expansionParameters.copy());
                        IBaseBackboneElement urlParam = childExpParams.getParameter("url");
                        if (urlParam != null) {
                            int ind = childExpParams.getParameter().indexOf(urlParam);
                            childExpParams.getParameter().remove(ind);
                            if (includedVS.hasUrl()) {
                                childExpParams.addParameter(this.fhirContext.getVersion().getVersion() == FhirVersionEnum.DSTU3 ? Parameters.newUriPart(this.fhirContext, "url", includedVS.getUrl(), new IBase[0]) : Parameters.newUrlPart(this.fhirContext, "url", includedVS.getUrl(), new IBase[0]));
                            }
                        }
                        if ((versionParam = childExpParams.getParameter("valueSetVersion")) != null) {
                            int ind = childExpParams.getParameter().indexOf(versionParam);
                            childExpParams.getParameter().remove(ind);
                            if (includedVS.hasVersion()) {
                                childExpParams.addParameter(Parameters.newStringPart(this.fhirContext, "valueSetVersion", includedVS.getVersion(), new IBase[0]));
                            }
                        }
                        this.expandValueSet(includedVS, childExpParams, terminologyEndpoint, valueSets, expandedList, repository, expansionTimestamp);
                    }
                    Optional.ofNullable(ValueSets.getCodesInExpansion(this.fhirContext, (IBaseResource)includedVS.get())).ifPresent(e -> e.forEach(code -> {
                        List<Code> existingCodes = ValueSets.getCodesInExpansion(this.fhirContext, (IBase)expansion);
                        if (existingCodes == null || existingCodes.stream().noneMatch(expandedCode -> code.getSystem().equals(expandedCode.getSystem()) && code.getCode().equals(expandedCode.getCode()) && (StringUtils.isEmpty((CharSequence)code.getVersion()) || code.getVersion().equals(expandedCode.getVersion())))) {
                            try {
                                ValueSets.addCodeToExpansion(this.fhirContext, (IBase)expansion, code);
                            }
                            catch (Exception ex) {
                                throw new UnprocessableEntityException(String.format("Encountered exception attempting to expand ValueSet %s: %s", includedVS.get().getId(), ex.getMessage()));
                            }
                        }
                    }));
                    if (includedVS.hasNaiveParameter() && !valueSet.hasNaiveParameter()) {
                        ValueSets.addParameterToExpansion(this.fhirContext, (IBase)expansion, valueSet.createNaiveParameter());
                    }
                } else {
                    throw new UnprocessableEntityException("Terminology Server expansion failed for ValueSet '" + valueSet.getUrl() + "' because Child ValueSet '" + reference + "' could not be found. ");
                }
            });
            try {
                ValueSets.setExpansionTimestamp(this.fhirContext, expansion, expansionTimestamp == null ? new Date() : expansionTimestamp);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e2) {
                throw new UnprocessableEntityException(e2.getMessage());
            }
            valueSet.setExpansion(expansion);
        } else if (valueSet.hasCompose()) {
            throw new UnprocessableEntityException("Cannot expand ValueSet without a terminology server: " + String.valueOf(valueSet.getId()));
        }
        expandedList.add(valueSet.getUrl());
    }
}

