/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.util.FhirTerser;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.utility.Ids;

public class Resources {
    private Resources() {
    }

    public static <T extends IBase> Optional<T> castOrThrow(IBase obj, Class<T> type, String errorMessage) {
        if (obj == null) {
            return Optional.empty();
        }
        if (type.isInstance(obj)) {
            return Optional.of((IBase)type.cast(obj));
        }
        throw new IllegalArgumentException(errorMessage);
    }

    public static <T extends IBaseResource, I extends IIdType> T newResource(Class<T> resourceClass, String idPart) {
        Preconditions.checkNotNull(resourceClass);
        Preconditions.checkNotNull((Object)idPart);
        Preconditions.checkArgument((!idPart.contains("/") ? 1 : 0) != 0, (Object)"idPart must be a simple id. Do not include resourceType or history");
        T resource = Resources.newResource(resourceClass);
        Object id = Ids.newId(resourceClass, idPart);
        resource.setId(id);
        return resource;
    }

    public static <T extends IBaseResource> T newResource(Class<T> resourceClass) {
        Preconditions.checkNotNull(resourceClass);
        IBaseResource resource = null;
        try {
            resource = (IBaseResource)resourceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("resourceClass must be a type with an empty default constructor to use this function");
        }
        return (T)resource;
    }

    public static <T extends IBaseBackboneElement> T newBackboneElement(Class<T> backboneElementClass) {
        Preconditions.checkNotNull(backboneElementClass);
        IBaseBackboneElement backboneElement = null;
        try {
            backboneElement = (IBaseBackboneElement)backboneElementClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("backboneElementClass must be a type with an empty default constructor to use this function");
        }
        return (T)backboneElement;
    }

    public static <T extends IBaseResource> T clone(T resource) {
        Preconditions.checkNotNull(resource);
        FhirTerser terser = resource.getStructureFhirVersionEnum().newContextCached().newTerser();
        return (T)terser.clone(resource);
    }

    public static String stringify(IBaseResource resource) {
        Preconditions.checkNotNull((Object)resource);
        return resource.getStructureFhirVersionEnum().newContextCached().newJsonParser().setPrettyPrint(true).encodeResourceToString(resource);
    }
}

