/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class Versions {
    private Versions() {
    }

    public static int compareVersions(String version1, String version2) {
        if (version1 == null || version2 == null) {
            return Versions.handleNulls(version1, version2);
        }
        boolean v1Valid = Versions.isValidSemver(version1);
        boolean v2Valid = Versions.isValidSemver(version2);
        if (!v1Valid || !v2Valid) {
            return Versions.handleInvalids(version1, version2, v1Valid, v2Valid);
        }
        String[] string1Vals = version1.split("\\.");
        String[] string2Vals = version2.split("\\.");
        int length = Math.max(string1Vals.length, string2Vals.length);
        for (int i = 0; i < length; ++i) {
            if (i > string1Vals.length - 1) {
                return -1;
            }
            if (i > string2Vals.length - 1) {
                return 1;
            }
            if (i == length - 1) break;
            if (string1Vals[i].equals(string2Vals[i])) continue;
            return Versions.stringOrNumberCompare(string1Vals[i], string2Vals[i]);
        }
        Pair<Integer, String> tail1 = Versions.parseTail(string1Vals[length - 1]);
        Pair<Integer, String> tail2 = Versions.parseTail(string2Vals[length - 1]);
        if (((Integer)tail1.getLeft()).equals(tail2.getLeft())) {
            return Versions.compareTails(tail1, tail2);
        }
        return Versions.intCompare((Integer)tail1.getLeft(), (Integer)tail2.getLeft());
    }

    private static Integer compareTails(Pair<Integer, String> tail1, Pair<Integer, String> tail2) {
        if (!((String)tail1.getRight()).isEmpty() && ((String)tail2.getRight()).isEmpty()) {
            return 1;
        }
        if (((String)tail1.getRight()).isEmpty() && !((String)tail2.getRight()).isEmpty()) {
            return -1;
        }
        int c = ((String)tail1.getRight()).compareTo((String)tail2.getRight());
        if (c > 0) {
            return 1;
        }
        if (c < 0) {
            return -1;
        }
        return 0;
    }

    private static Integer handleNulls(String version1, String version2) {
        if (version1 == null && version2 == null) {
            return 0;
        }
        if (version1 != null && version2 == null) {
            return -1;
        }
        return 1;
    }

    private static Integer handleInvalids(String version1, String version2, boolean v1Valid, boolean v2Valid) {
        if (!v1Valid && !v2Valid) {
            return Versions.stringOrNumberCompare(version1, version2);
        }
        if (v1Valid && !v2Valid) {
            return -1;
        }
        return 1;
    }

    private static Integer stringOrNumberCompare(String version1, String version2) {
        try {
            int d1 = Integer.parseInt(version1);
            int d2 = Integer.parseInt(version2);
            return Versions.intCompare(d1, d2);
        }
        catch (NumberFormatException e) {
            int c = version1.compareTo(version2);
            if (c > 0) {
                return 1;
            }
            if (c < 0) {
                return -1;
            }
            return 0;
        }
    }

    private static Integer intCompare(Integer d1, Integer d2) {
        if (d1 > d2) {
            return 1;
        }
        if (d2 > d1) {
            return -1;
        }
        return 0;
    }

    private static boolean isValidSemver(String check) {
        if (check.length() > 1 && !check.contains(".")) {
            return false;
        }
        String[] stringVals = check.split("\\.");
        for (int i = 0; i < stringVals.length - 1; ++i) {
            try {
                Integer.parseInt(stringVals[i]);
                continue;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        try {
            Versions.parseTail(stringVals[stringVals.length - 1]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static Pair<Integer, String> parseTail(String tail) {
        try {
            return Pair.of((Object)Integer.parseInt(tail), (Object)"");
        }
        catch (NumberFormatException e) {
            if (tail.contains("-")) {
                String[] splitDash = tail.split("-");
                String afterDash = String.join((CharSequence)"-", Arrays.copyOfRange(splitDash, 1, splitDash.length));
                return Pair.of((Object)Integer.parseInt(splitDash[0]), (Object)afterDash);
            }
            throw e;
        }
    }

    public static <ResourceType extends IBaseResource> ResourceType selectByVersion(List<ResourceType> resources, String version, Function<ResourceType, String> getVersion) {
        Preconditions.checkNotNull(resources);
        Preconditions.checkNotNull(getVersion);
        IBaseResource library = null;
        IBaseResource maxVersion = null;
        for (IBaseResource l : resources) {
            String currentVersion = getVersion.apply(l);
            if (version == null && currentVersion == null || version != null && version.equals(currentVersion)) {
                library = l;
            }
            if (maxVersion != null && Versions.compareVersions(currentVersion, getVersion.apply(maxVersion)) < 0) continue;
            maxVersion = l;
        }
        if ((version == null || library == null) && maxVersion != null) {
            return (ResourceType)maxVersion;
        }
        return (ResourceType)library;
    }
}

