/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.UrlType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Adapter<T extends IBase> {
    public static final Logger logger = LoggerFactory.getLogger(Adapter.class);

    public T get();

    default public void setExtension(List<? extends IBaseExtension<?, ?>> extensions) {
        try {
            this.getModelResolver().setValue(this.get(), "extension", null);
            this.getModelResolver().setValue(this.get(), "extension", extensions);
        }
        catch (Exception e) {
            logger.debug("Field 'extension' does not exist on Element type {}", (Object)this.get().fhirType());
        }
    }

    default public <E extends IBaseExtension<?, ?>> void addExtension(E extension) {
        try {
            this.getModelResolver().setValue(this.get(), "extension", Collections.singletonList(extension));
        }
        catch (Exception e) {
            logger.debug("Field 'extension' does not exist on Element type {}", (Object)this.get().fhirType());
        }
    }

    default public boolean hasExtension() {
        return !this.getExtension().isEmpty();
    }

    default public boolean hasExtension(String url) {
        return this.hasExtension((IBase)this.get(), url);
    }

    default public List<IBaseExtension<?, ?>> getExtension() {
        return this.getExtension((IBase)this.get());
    }

    default public IBaseExtension<?, ?> getExtensionByUrl(String url) {
        return this.getExtensionByUrl((IBase)this.get(), url);
    }

    default public List<? extends IBaseExtension<?, ?>> getExtensionsByUrl(String url) {
        return this.getExtensionsByUrl((IBase)this.get(), url);
    }

    public FhirContext fhirContext();

    public ModelResolver getModelResolver();

    default public <E extends IBaseExtension<?, ?>> List<E> getExtension(IBase base) {
        return this.resolvePathList(base, "extension").stream().map(e -> (IBaseExtension)e).collect(Collectors.toList());
    }

    default public List<IBaseExtension<?, ?>> getExtensionsByUrl(IBase base, String url) {
        return this.getExtension(base).stream().filter(e -> e.getUrl().equals(url)).collect(Collectors.toList());
    }

    default public IBaseExtension<?, ?> getExtensionByUrl(IBase base, String url) {
        return this.getExtensionsByUrl(base, url).stream().findFirst().orElse(null);
    }

    default public Boolean hasExtension(IBase base, String url) {
        return this.getExtension(base).stream().anyMatch(e -> e.getUrl().equals(url));
    }

    default public List<IBase> resolvePathList(IBase base, String path) {
        Object pathResult = this.getModelResolver().resolvePath((Object)base, path);
        return pathResult instanceof List ? (List)pathResult : new ArrayList();
    }

    default public <B extends IBase> List<B> resolvePathList(IBase base, String path, Class<B> clazz) {
        return this.resolvePathList(base, path).stream().map(i -> i).collect(Collectors.toList());
    }

    default public String resolvePathString(IBase base, String path) {
        IPrimitiveType result = (IPrimitiveType)this.resolvePath(base, path);
        return result == null ? null : (String)result.getValue();
    }

    default public IBase resolvePath(IBase base, String path) {
        return (IBase)this.getModelResolver().resolvePath((Object)base, path);
    }

    default public <B extends IBase> B resolvePath(IBase base, String path, Class<B> clazz) {
        return (B)this.resolvePath(base, path);
    }

    public static <T extends ICompositeType> T newPeriod(FhirVersionEnum version) {
        switch (version) {
            case DSTU3: {
                return (T)new org.hl7.fhir.dstu3.model.Period();
            }
            case R4: {
                return (T)new Period();
            }
            case R5: {
                return (T)new org.hl7.fhir.r5.model.Period();
            }
        }
        throw new UnprocessableEntityException("Unsupported version: " + version.toString());
    }

    public static <T extends IPrimitiveType<String>> T newStringType(FhirVersionEnum version, String string) {
        switch (version) {
            case DSTU3: {
                return (T)new org.hl7.fhir.dstu3.model.StringType(string);
            }
            case R4: {
                return (T)new org.hl7.fhir.r4.model.StringType(string);
            }
            case R5: {
                return (T)new StringType(string);
            }
        }
        throw new UnprocessableEntityException("Unsupported version: " + version.toString());
    }

    public static <T extends IPrimitiveType<String>> T newUriType(FhirVersionEnum version, String string) {
        switch (version) {
            case DSTU3: {
                return (T)new UriType(string);
            }
            case R4: {
                return (T)new org.hl7.fhir.r4.model.UriType(string);
            }
            case R5: {
                return (T)new org.hl7.fhir.r5.model.UriType(string);
            }
        }
        throw new UnprocessableEntityException("Unsupported version: " + version.toString());
    }

    public static <T extends IPrimitiveType<String>> T newUrlType(FhirVersionEnum version, String string) {
        switch (version) {
            case DSTU3: {
                return (T)new UriType(string);
            }
            case R4: {
                return (T)new org.hl7.fhir.r4.model.UrlType(string);
            }
            case R5: {
                return (T)new UrlType(string);
            }
        }
        throw new UnprocessableEntityException("Unsupported version: " + version.toString());
    }

    public static <T extends IPrimitiveType<Date>> T newDateType(FhirVersionEnum version, Date date) {
        switch (version) {
            case DSTU3: {
                return (T)new org.hl7.fhir.dstu3.model.DateType(date);
            }
            case R4: {
                return (T)new DateType(date);
            }
            case R5: {
                return (T)new org.hl7.fhir.r5.model.DateType(date);
            }
        }
        throw new UnprocessableEntityException("Unsupported version: " + version.toString());
    }

    public static <T extends IPrimitiveType<Date>> T newDateTimeType(FhirVersionEnum version, Date date) {
        switch (version) {
            case DSTU3: {
                return (T)new DateTimeType(date);
            }
            case R4: {
                return (T)new org.hl7.fhir.r4.model.DateTimeType(date);
            }
            case R5: {
                return (T)new org.hl7.fhir.r5.model.DateTimeType(date);
            }
        }
        throw new UnprocessableEntityException("Unsupported version: " + version.toString());
    }
}

