/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Versions;
import org.opencds.cqf.fhir.utility.adapter.Adapter;
import org.opencds.cqf.fhir.utility.adapter.AdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.DependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.ResourceAdapter;
import org.opencds.cqf.fhir.utility.visitor.IKnowledgeArtifactVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface KnowledgeArtifactAdapter
extends ResourceAdapter {
    public static final Logger logger = LoggerFactory.getLogger(KnowledgeArtifactAdapter.class);
    public static final String releaseLabelUrl = "http://hl7.org/fhir/StructureDefinition/artifact-releaseLabel";
    public static final String releaseDescriptionUrl = "http://hl7.org/fhir/StructureDefinition/artifact-releaseDescription";
    public static final String usPhContextTypeUrl = "http://hl7.org/fhir/us/ecr/CodeSystem/us-ph-usage-context-type";
    public static final String contextTypeUrl = "http://terminology.hl7.org/CodeSystem/usage-context-type";
    public static final String contextUrl = "http://hl7.org/fhir/us/ecr/CodeSystem/us-ph-usage-context";
    public static final String isOwnedUrl = "http://hl7.org/fhir/StructureDefinition/artifact-isOwned";

    @Override
    public IDomainResource get();

    public IDomainResource copy();

    default public IIdType getId() {
        return this.get().getIdElement();
    }

    default public void setId(IIdType id) {
        this.get().setId(id);
    }

    default public String getName() {
        return this.resolvePathString((IBase)this.get(), "name");
    }

    default public void setName(String name) {
        this.getModelResolver().setValue((Object)this.get(), "name", Adapter.newStringType(this.get().getStructureFhirVersionEnum(), name));
    }

    default public boolean hasTitle() {
        return StringUtils.isNotBlank((CharSequence)this.getTitle());
    }

    default public String getTitle() {
        return this.resolvePathString((IBase)this.get(), "title");
    }

    default public void setTitle(String title) {
        this.getModelResolver().setValue((Object)this.get(), "title", (Object)title);
    }

    default public String getDescriptor() {
        return String.format("%s %s%s", this.get().fhirType(), this.hasTitle() ? this.getTitle() : this.getName(), this.hasVersion() ? ", " + this.getVersion() : "");
    }

    default public boolean hasUrl() {
        return StringUtils.isNotBlank((CharSequence)this.getUrl());
    }

    default public String getUrl() {
        return this.resolvePathString((IBase)this.get(), "url");
    }

    default public void setUrl(String url) {
        this.getModelResolver().setValue((Object)this.get(), "url", Adapter.newUriType(this.get().getStructureFhirVersionEnum(), url));
    }

    default public boolean hasVersion() {
        return StringUtils.isNotBlank((CharSequence)this.getVersion());
    }

    default public String getVersion() {
        return this.resolvePathString((IBase)this.get(), "version");
    }

    default public void setVersion(String version) {
        this.getModelResolver().setValue((Object)this.get(), "version", Adapter.newStringType(this.get().getStructureFhirVersionEnum(), version));
    }

    default public String getCanonical() {
        if (!this.hasUrl()) {
            return this.getId().getValueAsString();
        }
        return this.getUrl().concat(this.hasVersion() ? String.format("|%s", this.getVersion()) : "");
    }

    public List<IDependencyInfo> getDependencies();

    default public String getReferenceSource() {
        return this.hasVersion() ? this.getUrl() + "|" + this.getVersion() : this.getUrl();
    }

    default public void addProfileReferences(List<IDependencyInfo> references, String referenceSource) {
        this.get().getMeta().getProfile().stream().map(p -> (IBaseHasExtensions)p).forEach(profile -> references.add(new DependencyInfo(referenceSource, ((IPrimitiveType)profile).getValueAsString(), profile.getExtension(), reference -> ((IPrimitiveType)profile).setValue(reference))));
    }

    default public Date getApprovalDate() {
        IPrimitiveType approvalDate = this.resolvePath((IBase)this.get(), "approvalDate", IPrimitiveType.class);
        return approvalDate == null ? null : (Date)approvalDate.getValue();
    }

    default public void setApprovalDate(Date approvalDate) {
        try {
            this.getModelResolver().setValue((Object)this.get(), "approvalDate", Adapter.newDateType(this.get().getStructureFhirVersionEnum(), approvalDate));
        }
        catch (Exception e) {
            logger.debug("Field 'approvalDate' does not exist on Resource type {}", (Object)this.get().fhirType());
        }
    }

    default public Date getDate() {
        IPrimitiveType date = this.resolvePath((IBase)this.get(), "date", IPrimitiveType.class);
        return date == null ? null : (Date)date.getValue();
    }

    default public void setDate(Date date) {
        this.getModelResolver().setValue((Object)this.get(), "date", Adapter.newDateTimeType(this.get().getStructureFhirVersionEnum(), date));
    }

    default public void setDateElement(IPrimitiveType<Date> date) {
        this.getModelResolver().setValue((Object)this.get(), "date", date);
    }

    default public String getPurpose() {
        return this.resolvePathString((IBase)this.get(), "purpose");
    }

    public String getStatus();

    public void setStatus(String var1);

    default public ICompositeType getEffectivePeriod() {
        ICompositeType effectivePeriod = this.resolvePath((IBase)this.get(), "effectivePeriod", ICompositeType.class);
        return effectivePeriod == null ? Adapter.newPeriod(this.get().getStructureFhirVersionEnum()) : effectivePeriod;
    }

    default public void setEffectivePeriod(ICompositeType period) {
        try {
            this.getModelResolver().setValue((Object)this.get(), "effectivePeriod", (Object)period);
        }
        catch (Exception e) {
            logger.debug("Field 'effectivePeriod' does not exist on Resource type {}", (Object)this.get().fhirType());
        }
    }

    default public boolean getExperimental() {
        IPrimitiveType experimental = this.resolvePath((IBase)this.get(), "experimental", IPrimitiveType.class);
        return experimental == null ? false : (Boolean)experimental.getValue();
    }

    public static <T extends ICompositeType & IBaseHasExtensions> T newRelatedArtifact(FhirVersionEnum version, String type, String reference, String display) {
        switch (version) {
            case DSTU3: {
                RelatedArtifact dstu3 = new RelatedArtifact();
                dstu3.setType(RelatedArtifact.RelatedArtifactType.fromCode((String)type)).setResource(new Reference(reference)).setDisplay(display);
                return (T)dstu3;
            }
            case R4: {
                org.hl7.fhir.r4.model.RelatedArtifact r4 = new org.hl7.fhir.r4.model.RelatedArtifact();
                r4.setType(RelatedArtifact.RelatedArtifactType.fromCode((String)type)).setResource(reference).setDisplay(display);
                return (T)r4;
            }
            case R5: {
                org.hl7.fhir.r5.model.RelatedArtifact r5 = new org.hl7.fhir.r5.model.RelatedArtifact();
                r5.setType(RelatedArtifact.RelatedArtifactType.fromCode((String)type)).setResource(reference).setDisplay(display);
                return (T)r5;
            }
        }
        throw new UnprocessableEntityException("Unsupported version: " + version.toString());
    }

    public static <T extends ICompositeType & IBaseHasExtensions> String getRelatedArtifactReference(T relatedArtifact) {
        if (relatedArtifact instanceof RelatedArtifact) {
            return ((RelatedArtifact)relatedArtifact).getResource().getReference();
        }
        if (relatedArtifact instanceof org.hl7.fhir.r4.model.RelatedArtifact) {
            return ((org.hl7.fhir.r4.model.RelatedArtifact)relatedArtifact).getResource();
        }
        if (relatedArtifact instanceof org.hl7.fhir.r5.model.RelatedArtifact) {
            return ((org.hl7.fhir.r5.model.RelatedArtifact)relatedArtifact).getResource();
        }
        throw new UnprocessableEntityException("Must be a valid RelatedArtifact");
    }

    public static <T extends ICompositeType & IBaseHasExtensions> String getRelatedArtifactType(T relatedArtifact) {
        if (relatedArtifact instanceof RelatedArtifact) {
            return ((RelatedArtifact)relatedArtifact).getType().toCode();
        }
        if (relatedArtifact instanceof org.hl7.fhir.r4.model.RelatedArtifact) {
            return ((org.hl7.fhir.r4.model.RelatedArtifact)relatedArtifact).getType().toCode();
        }
        if (relatedArtifact instanceof org.hl7.fhir.r5.model.RelatedArtifact) {
            return ((org.hl7.fhir.r5.model.RelatedArtifact)relatedArtifact).getType().toCode();
        }
        throw new UnprocessableEntityException("Must be a valid RelatedArtifact");
    }

    public static <T extends ICompositeType & IBaseHasExtensions> void setRelatedArtifactReference(T relatedArtifact, String reference, String display) {
        if (relatedArtifact instanceof RelatedArtifact) {
            ((RelatedArtifact)relatedArtifact).getResource().setReference(reference).setDisplay(display);
        } else if (relatedArtifact instanceof org.hl7.fhir.r4.model.RelatedArtifact) {
            ((org.hl7.fhir.r4.model.RelatedArtifact)relatedArtifact).setResource(reference).setDisplay(display);
        } else if (relatedArtifact instanceof org.hl7.fhir.r5.model.RelatedArtifact) {
            ((org.hl7.fhir.r5.model.RelatedArtifact)relatedArtifact).setResource(reference).setDisplay(display);
        } else {
            throw new UnprocessableEntityException("Must be a valid RelatedArtifact");
        }
    }

    default public boolean hasRelatedArtifact() {
        return !this.getRelatedArtifact().isEmpty();
    }

    default public <T extends ICompositeType & IBaseHasExtensions> List<T> getRelatedArtifact() {
        return this.resolvePathList((IBase)this.get(), "relatedArtifact").stream().map(r -> (ICompositeType)r).collect(Collectors.toList());
    }

    default public <T extends ICompositeType & IBaseHasExtensions> void setRelatedArtifact(List<T> relatedArtifacts) {
        try {
            this.getModelResolver().setValue((Object)this.get(), "relatedArtifact", null);
            this.getModelResolver().setValue((Object)this.get(), "relatedArtifact", relatedArtifacts);
        }
        catch (Exception e) {
            logger.debug("Field 'relatedArtifact' does not exist on Resource type {}", (Object)this.get().fhirType());
        }
    }

    public <T extends ICompositeType & IBaseHasExtensions> List<T> getRelatedArtifactsOfType(String var1);

    default public <T extends ICompositeType & IBaseHasExtensions> List<T> getComponents() {
        return this.getRelatedArtifactsOfType("composed-of");
    }

    public static <T extends ICompositeType & IBaseHasExtensions> boolean checkIfRelatedArtifactIsOwned(T relatedArtifact) {
        return ((IBaseHasExtensions)relatedArtifact).getExtension().stream().anyMatch(ext -> ext.getUrl().equals(isOwnedUrl));
    }

    default public List<IDependencyInfo> combineComponentsAndDependencies() {
        String referenceSource = this.hasVersion() ? this.getUrl() + "|" + this.getVersion() : this.getUrl();
        return Stream.concat(this.getComponents().stream().filter(ra -> ra != null).map(ra -> DependencyInfo.convertRelatedArtifact(ra, referenceSource)), this.getDependencies().stream()).collect(Collectors.toList());
    }

    default public IBase accept(IKnowledgeArtifactVisitor visitor, Repository repository, IBaseParameters operationParameters) {
        return visitor.visit(this, repository, operationParameters);
    }

    default public <T extends ICompositeType & IBaseHasExtensions> List<T> getOwnedRelatedArtifacts() {
        return this.getRelatedArtifactsOfType("composed-of").stream().filter(ra -> KnowledgeArtifactAdapter.checkIfRelatedArtifactIsOwned(ra)).collect(Collectors.toList());
    }

    public static boolean isSupportedMetadataResource(IBaseResource resource) {
        return resource instanceof org.hl7.fhir.dstu3.model.MetadataResource || resource instanceof MetadataResource || resource instanceof org.hl7.fhir.r5.model.MetadataResource;
    }

    public static Optional<IDomainResource> findLatestVersion(IBaseBundle bundle) {
        List sorted = BundleHelper.getEntryResources(bundle).stream().filter(r -> KnowledgeArtifactAdapter.isSupportedMetadataResource(r)).map(r -> (KnowledgeArtifactAdapter)AdapterFactory.forFhirVersion(r.getStructureFhirVersionEnum()).createResource((IBaseResource)r)).sorted((a, b) -> Versions.compareVersions(a.getVersion(), b.getVersion())).collect(Collectors.toList());
        if (!sorted.isEmpty()) {
            return Optional.of(((KnowledgeArtifactAdapter)sorted.get(0)).get());
        }
        return Optional.ofNullable(null);
    }

    default public Optional<IBaseParameters> getExpansionParameters() {
        return Optional.empty();
    }

    default public IBaseResource getPrimaryLibrary(Repository repository) {
        return this.get().fhirType().equals("Library") ? this.get() : null;
    }
}

