/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.dstu3;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.dstu3.model.DataRequirement;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.adapter.DependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.dstu3.KnowledgeArtifactAdapter;

class PlanDefinitionAdapter
extends KnowledgeArtifactAdapter {
    public PlanDefinitionAdapter(IDomainResource planDefinition) {
        super(planDefinition);
        if (!(planDefinition instanceof PlanDefinition)) {
            throw new IllegalArgumentException("resource passed as planDefinition argument is not a PlanDefinition resource");
        }
    }

    public PlanDefinitionAdapter(PlanDefinition planDefinition) {
        super((MetadataResource)planDefinition);
    }

    protected PlanDefinition getPlanDefinition() {
        return (PlanDefinition)this.resource;
    }

    @Override
    public PlanDefinition get() {
        return this.getPlanDefinition();
    }

    public PlanDefinition copy() {
        return this.get().copy();
    }

    @Override
    public List<IDependencyInfo> getDependencies() {
        ArrayList<IDependencyInfo> references = new ArrayList<IDependencyInfo>();
        String referenceSource = this.getReferenceSource();
        this.addProfileReferences(references, referenceSource);
        references.addAll(this.getRelatedArtifact().stream().map(ra -> DependencyInfo.convertRelatedArtifact(ra, referenceSource)).collect(Collectors.toList()));
        List libraries = this.getPlanDefinition().getLibrary();
        for (Reference ref : libraries) {
            DependencyInfo dependency = new DependencyInfo(referenceSource, ref.getReference(), ref.getExtension(), reference -> ref.setReference(reference));
            references.add(dependency);
        }
        this.getPlanDefinition().getAction().forEach(action -> this.getDependenciesOfAction((PlanDefinition.PlanDefinitionActionComponent)action, (List<IDependencyInfo>)references, referenceSource));
        this.getPlanDefinition().getExtension().stream().filter(ext -> ext.getUrl().contains("cpg-partOf")).filter(ext -> ext.hasValue()).findAny().ifPresent(ext -> references.add(new DependencyInfo(referenceSource, (String)((UriType)ext.getValue()).getValue(), ext.getExtension(), reference -> ((UriType)ext.getValue()).setValue(reference))));
        return references;
    }

    private void getDependenciesOfAction(PlanDefinition.PlanDefinitionActionComponent action, List<IDependencyInfo> references, String referenceSource) {
        action.getTriggerDefinition().stream().map(t -> t.getEventData()).forEach(eventData -> {
            eventData.getProfile().stream().filter(PrimitiveType::hasValue).forEach(profile -> references.add(new DependencyInfo(referenceSource, (String)profile.getValue(), profile.getExtension(), reference -> profile.setValue(reference))));
            eventData.getCodeFilter().stream().filter(cf -> cf.hasValueSet()).forEach(cf -> references.add(this.dependencyFromDataRequirementCodeFilter((DataRequirement.DataRequirementCodeFilterComponent)cf)));
        });
        Stream.concat(action.getInput().stream(), action.getOutput().stream()).forEach(inputOrOutput -> {
            inputOrOutput.getProfile().stream().filter(PrimitiveType::hasValue).forEach(profile -> references.add(new DependencyInfo(referenceSource, (String)profile.getValue(), profile.getExtension(), reference -> profile.setValue(reference))));
            inputOrOutput.getCodeFilter().stream().filter(cf -> cf.hasValueSet()).forEach(cf -> references.add(this.dependencyFromDataRequirementCodeFilter((DataRequirement.DataRequirementCodeFilterComponent)cf)));
        });
        Reference definition = action.getDefinition();
        if (definition != null && definition.hasReference()) {
            references.add(new DependencyInfo(referenceSource, definition.getReference(), definition.getExtension(), reference -> definition.setReference(reference)));
        }
        action.getAction().forEach(nestedAction -> this.getDependenciesOfAction((PlanDefinition.PlanDefinitionActionComponent)nestedAction, references, referenceSource));
    }

    private DependencyInfo dependencyFromDataRequirementCodeFilter(DataRequirement.DataRequirementCodeFilterComponent cf) {
        Type vs = cf.getValueSet();
        if (vs instanceof StringType) {
            return new DependencyInfo(this.getPlanDefinition().getUrl(), (String)((StringType)vs).getValue(), vs.getExtension(), reference -> ((StringType)vs).setValue(reference));
        }
        if (vs instanceof Reference) {
            return new DependencyInfo(this.getPlanDefinition().getUrl(), ((Reference)vs).getReference(), vs.getExtension(), reference -> ((Reference)vs).setReference(reference));
        }
        return null;
    }

    @Override
    public IBaseResource getPrimaryLibrary(Repository repository) {
        List libraries = this.getPlanDefinition().getLibrary();
        return libraries.isEmpty() ? null : SearchHelper.searchRepositoryByCanonical(repository, ((Reference)libraries.get(0)).getReferenceElement());
    }
}

