/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r4;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.Type;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.adapter.DependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.r4.KnowledgeArtifactAdapter;

public class PlanDefinitionAdapter
extends KnowledgeArtifactAdapter {
    public PlanDefinitionAdapter(IDomainResource planDefinition) {
        super(planDefinition);
        if (!(planDefinition instanceof PlanDefinition)) {
            throw new IllegalArgumentException("resource passed as planDefinition argument is not a PlanDefinition resource");
        }
    }

    public PlanDefinitionAdapter(PlanDefinition planDefinition) {
        super((MetadataResource)planDefinition);
    }

    protected PlanDefinition getPlanDefinition() {
        return (PlanDefinition)this.resource;
    }

    @Override
    public PlanDefinition get() {
        return this.getPlanDefinition();
    }

    public PlanDefinition copy() {
        return this.get().copy();
    }

    @Override
    public List<IDependencyInfo> getDependencies() {
        ArrayList<IDependencyInfo> references = new ArrayList<IDependencyInfo>();
        String referenceSource = this.getReferenceSource();
        this.addProfileReferences(references, referenceSource);
        references.addAll(this.getRelatedArtifact().stream().map(ra -> DependencyInfo.convertRelatedArtifact(ra, referenceSource)).collect(Collectors.toList()));
        List libraries = this.getPlanDefinition().getLibrary();
        for (CanonicalType ct : libraries) {
            DependencyInfo dependency = new DependencyInfo(referenceSource, (String)ct.getValue(), ct.getExtension(), reference -> ct.setValue(reference));
            references.add(dependency);
        }
        this.getPlanDefinition().getAction().forEach(action -> this.getDependenciesOfAction((PlanDefinition.PlanDefinitionActionComponent)action, (List<IDependencyInfo>)references, referenceSource));
        this.getPlanDefinition().getExtension().stream().filter(ext -> ext.getUrl().contains("cpg-partOf")).filter(ext -> ext.hasValue()).findAny().ifPresent(ext -> references.add(new DependencyInfo(referenceSource, (String)((CanonicalType)ext.getValue()).getValue(), ext.getExtension(), reference -> ext.setValue((Type)new CanonicalType(reference)))));
        return references;
    }

    private void getDependenciesOfAction(PlanDefinition.PlanDefinitionActionComponent action, List<IDependencyInfo> references, String referenceSource) {
        action.getTrigger().stream().flatMap(t -> t.getData().stream()).forEach(eventData -> {
            eventData.getProfile().stream().filter(profile -> profile.hasValue()).forEach(profile -> references.add(new DependencyInfo(referenceSource, (String)profile.getValue(), profile.getExtension(), reference -> profile.setValue(reference))));
            eventData.getCodeFilter().stream().filter(cf -> cf.hasValueSet()).forEach(cf -> references.add(new DependencyInfo(referenceSource, cf.getValueSet(), cf.getExtension(), reference -> cf.setValueSet(reference))));
        });
        action.getCondition().stream().filter(c -> c.hasExpression()).map(c -> c.getExpression()).filter(e -> e.hasReference()).forEach(expression -> references.add(new DependencyInfo(referenceSource, expression.getReference(), expression.getExtension(), reference -> expression.setReference(reference))));
        action.getDynamicValue().stream().filter(dv -> dv.hasExpression()).map(dv -> dv.getExpression()).filter(e -> e.hasReference()).forEach(expression -> references.add(new DependencyInfo(referenceSource, expression.getReference(), expression.getExtension(), reference -> expression.setReference(reference))));
        Stream.concat(action.getInput().stream(), action.getOutput().stream()).forEach(inputOrOutput -> {
            inputOrOutput.getProfile().stream().filter(profile -> profile.hasValue()).forEach(profile -> references.add(new DependencyInfo(referenceSource, (String)profile.getValue(), profile.getExtension(), reference -> profile.setValue(reference))));
            inputOrOutput.getCodeFilter().stream().filter(cf -> cf.hasValueSet()).forEach(cf -> references.add(new DependencyInfo(referenceSource, cf.getValueSet(), cf.getExtension(), reference -> cf.setValueSet(reference))));
        });
        CanonicalType definition = action.getDefinitionCanonicalType();
        if (definition != null && definition.hasValue()) {
            references.add(new DependencyInfo(referenceSource, (String)definition.getValue(), definition.getExtension(), reference -> definition.setValue(reference)));
        }
        action.getAction().forEach(nestedAction -> this.getDependenciesOfAction((PlanDefinition.PlanDefinitionActionComponent)nestedAction, references, referenceSource));
    }

    @Override
    public IBaseResource getPrimaryLibrary(Repository repository) {
        List libraries = this.getPlanDefinition().getLibrary();
        return libraries.isEmpty() ? null : SearchHelper.searchRepositoryByCanonical(repository, (CanonicalType)libraries.get(0));
    }
}

