/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r4;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.Type;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.adapter.DependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.r4.KnowledgeArtifactAdapter;

public class QuestionnaireAdapter
extends KnowledgeArtifactAdapter
implements org.opencds.cqf.fhir.utility.adapter.QuestionnaireAdapter {
    public QuestionnaireAdapter(IDomainResource questionnaire) {
        super(questionnaire);
        if (!(questionnaire instanceof Questionnaire)) {
            throw new IllegalArgumentException("resource passed as questionnaire argument is not a Questionnaire resource");
        }
    }

    public QuestionnaireAdapter(Questionnaire questionnaire) {
        super((MetadataResource)questionnaire);
    }

    protected Questionnaire getQuestionnaire() {
        return (Questionnaire)this.resource;
    }

    @Override
    public Questionnaire get() {
        return this.getQuestionnaire();
    }

    public Questionnaire copy() {
        return this.get().copy();
    }

    @Override
    public List<IDependencyInfo> getDependencies() {
        ArrayList<IDependencyInfo> references = new ArrayList<IDependencyInfo>();
        String referenceSource = this.getReferenceSource();
        this.addProfileReferences(references, referenceSource);
        this.getQuestionnaire().getDerivedFrom().forEach(derivedRef -> references.add(new DependencyInfo(referenceSource, derivedRef.asStringValue(), derivedRef.getExtension(), reference -> derivedRef.setValue(reference))));
        this.getQuestionnaire().getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/cqf-library").forEach(libraryExt -> references.add(new DependencyInfo(referenceSource, ((CanonicalType)libraryExt.getValue()).asStringValue(), libraryExt.getExtension(), reference -> libraryExt.setValue((Type)new CanonicalType(reference)))));
        this.getQuestionnaire().getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/variable").stream().map(e -> (Expression)e.getValue()).filter(e -> e.hasReference()).forEach(expression -> references.add(new DependencyInfo(referenceSource, expression.getReference(), expression.getExtension(), reference -> expression.setReference(reference))));
        this.getQuestionnaire().getItem().forEach(item -> this.getDependenciesOfItem((Questionnaire.QuestionnaireItemComponent)item, (List<IDependencyInfo>)references, referenceSource));
        return references;
    }

    private void getDependenciesOfItem(Questionnaire.QuestionnaireItemComponent item, List<IDependencyInfo> references, String referenceSource) {
        if (item.hasDefinition()) {
            String definition = item.getDefinition().split("#")[0];
            references.add(new DependencyInfo(referenceSource, definition, item.getExtension(), null));
        }
        if (item.hasAnswerValueSet()) {
            references.add(new DependencyInfo(referenceSource, item.getAnswerValueSet(), item.getExtension(), reference -> item.setAnswerValueSet(reference)));
        }
        item.getExtension().stream().filter(e -> REFERENCE_EXTENSIONS.contains(e.getUrl())).forEach(referenceExt -> references.add(new DependencyInfo(referenceSource, ((CanonicalType)referenceExt.getValue()).asStringValue(), referenceExt.getExtension(), reference -> referenceExt.setValue((Type)new CanonicalType(reference)))));
        item.getExtension().stream().filter(e -> EXPRESSION_EXTENSIONS.contains(e.getUrl())).map(e -> (Expression)e.getValue()).filter(e -> e.hasReference()).forEach(expression -> references.add(new DependencyInfo(referenceSource, expression.getReference(), expression.getExtension(), reference -> expression.setReference(reference))));
        item.getItem().forEach(childItem -> this.getDependenciesOfItem((Questionnaire.QuestionnaireItemComponent)childItem, references, referenceSource));
    }

    @Override
    public IBaseResource getPrimaryLibrary(Repository repository) {
        Extension library = this.getQuestionnaire().getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/cqf-library");
        return library == null ? null : SearchHelper.searchRepositoryByCanonical(repository, (CanonicalType)library.getValue());
    }
}

