/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r5;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.UriType;
import org.opencds.cqf.fhir.utility.adapter.DependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.r5.KnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.r5.LibraryAdapter;

public class MeasureAdapter
extends KnowledgeArtifactAdapter
implements org.opencds.cqf.fhir.utility.adapter.MeasureAdapter {
    private boolean checkedEffectiveDataRequirements;
    private Library effectiveDataRequirements;
    private LibraryAdapter effectiveDataRequirementsAdapter;

    public MeasureAdapter(IDomainResource measure) {
        super(measure);
        if (!(measure instanceof Measure)) {
            throw new IllegalArgumentException("resource passed as measure argument is not a Measure resource");
        }
    }

    public MeasureAdapter(Measure measure) {
        super((MetadataResource)measure);
    }

    protected Measure getMeasure() {
        return (Measure)this.resource;
    }

    @Override
    public Measure get() {
        return this.getMeasure();
    }

    public Measure copy() {
        return this.get().copy();
    }

    private String getEdrReferenceString(Extension edrExtension) {
        return edrExtension.getUrl().contains("cqfm") ? ((Reference)edrExtension.getValue()).getReference() : (String)((UriType)edrExtension.getValue()).getValue();
    }

    private Consumer<String> getEdrReferenceConsumer(Extension edrExtension) {
        return edrExtension.getUrl().contains("cqfm") ? reference -> edrExtension.setValue((DataType)new Reference(reference)) : reference -> edrExtension.setValue((DataType)new CanonicalType(reference));
    }

    private void findEffectiveDataRequirements() {
        if (!this.checkedEffectiveDataRequirements) {
            List edrExtensions = this.getMeasure().getExtension().stream().filter(ext -> ext.getUrl().endsWith("-effectiveDataRequirements")).filter(ext -> ext.hasValue()).collect(Collectors.toList());
            Extension edrExtension = edrExtensions.size() == 1 ? (Extension)edrExtensions.get(0) : null;
            Optional<String> maybeEdrReference = Optional.ofNullable(edrExtension).map(e -> this.getEdrReferenceString((Extension)e));
            if (edrExtension != null) {
                String edrReference = maybeEdrReference.get();
                for (Resource c : this.getMeasure().getContained()) {
                    if (!c.hasId() || !edrReference.equals(c.getId()) && !edrReference.equals("#" + c.getId()) || !(c instanceof Library)) continue;
                    this.effectiveDataRequirements = (Library)c;
                    this.effectiveDataRequirementsAdapter = new LibraryAdapter(this.effectiveDataRequirements);
                }
            }
            this.checkedEffectiveDataRequirements = true;
        }
    }

    @Override
    public List<IDependencyInfo> getDependencies() {
        Object dependency;
        ArrayList<IDependencyInfo> references = new ArrayList<IDependencyInfo>();
        String referenceSource = this.getReferenceSource();
        this.addProfileReferences(references, referenceSource);
        this.findEffectiveDataRequirements();
        if (this.effectiveDataRequirements != null) {
            references.addAll(this.effectiveDataRequirementsAdapter.getDependencies());
            return references;
        }
        references.addAll(this.getRelatedArtifact().stream().map(ra -> DependencyInfo.convertRelatedArtifact(ra, referenceSource)).collect(Collectors.toList()));
        for (CanonicalType library : this.getMeasure().getLibrary()) {
            dependency = new DependencyInfo(referenceSource, (String)library.getValue(), library.getExtension(), reference -> library.setValue(reference));
            references.add((IDependencyInfo)dependency);
        }
        for (Measure.MeasureGroupComponent group : this.getMeasure().getGroup()) {
            DependencyInfo dependency2;
            for (Measure.MeasureGroupPopulationComponent population : group.getPopulation()) {
                if (!population.getCriteria().hasReference()) continue;
                dependency2 = new DependencyInfo(referenceSource, population.getCriteria().getReference(), population.getCriteria().getExtension(), reference -> population.getCriteria().setReference(reference));
                references.add(dependency2);
            }
            for (Measure.MeasureGroupStratifierComponent stratifier : group.getStratifier()) {
                if (stratifier.getCriteria().hasReference()) {
                    dependency2 = new DependencyInfo(referenceSource, stratifier.getCriteria().getReference(), stratifier.getCriteria().getExtension(), reference -> stratifier.getCriteria().setReference(reference));
                    references.add(dependency2);
                }
                for (Measure.MeasureGroupStratifierComponentComponent component : stratifier.getComponent()) {
                    if (!component.getCriteria().hasReference()) continue;
                    DependencyInfo stratifierComponentDep = new DependencyInfo(referenceSource, component.getCriteria().getReference(), component.getCriteria().getExtension(), reference -> component.getCriteria().setReference(reference));
                    references.add(stratifierComponentDep);
                }
            }
        }
        for (Measure.MeasureSupplementalDataComponent supplement : this.getMeasure().getSupplementalData()) {
            if (!supplement.getCriteria().hasReference()) continue;
            dependency = new DependencyInfo(referenceSource, supplement.getCriteria().getReference(), supplement.getCriteria().getExtension(), reference -> supplement.getCriteria().setReference(reference));
            references.add((IDependencyInfo)dependency);
        }
        this.get().getExtension().stream().filter(e -> CANONICAL_EXTENSIONS.contains(e.getUrl())).forEach(referenceExt -> references.add(new DependencyInfo(referenceSource, this.getEdrReferenceString((Extension)referenceExt), referenceExt.getExtension(), this.getEdrReferenceConsumer((Extension)referenceExt))));
        this.get().getExtension().stream().filter(e -> REFERENCE_EXTENSIONS.contains(e.getUrl())).forEach(referenceExt -> references.add(new DependencyInfo(referenceSource, ((Reference)referenceExt.getValue()).getReference(), referenceExt.getExtension(), reference -> referenceExt.setValue((DataType)new Reference(reference)))));
        this.get().getExtensionsByUrl("http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-component").forEach(ext -> {
            RelatedArtifact ref = (RelatedArtifact)ext.getValue();
            if (ref.hasResource()) {
                DependencyInfo dep = new DependencyInfo(referenceSource, ref.getResource(), ref.getExtension(), reference -> ref.setResource(reference));
                references.add(dep);
            }
        });
        return references;
    }
}

