/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r5;

import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.opencds.cqf.fhir.utility.adapter.r5.ResourceAdapter;

class ParametersAdapter
extends ResourceAdapter
implements org.opencds.cqf.fhir.utility.adapter.ParametersAdapter {
    private Parameters parameters;

    public ParametersAdapter(IBaseResource parameters) {
        super(parameters);
        if (!parameters.fhirType().equals("Parameters")) {
            throw new IllegalArgumentException("resource passed as parameters argument is not a Parameters resource");
        }
        this.parameters = (Parameters)parameters;
    }

    protected Parameters getParameters() {
        return this.parameters;
    }

    public List<Parameters.ParametersParameterComponent> getParameter() {
        return this.getParameters().getParameter().stream().collect(Collectors.toList());
    }

    public List<DataType> getParameterValues(String name) {
        return this.getParameters().getParameterValues(name);
    }

    public Parameters.ParametersParameterComponent getParameter(String name) {
        return this.getParameters().getParameter(name);
    }

    @Override
    public void setParameter(List<IBaseBackboneElement> parametersParameterComponents) {
        this.getParameters().setParameter(parametersParameterComponents.stream().map(x -> (Parameters.ParametersParameterComponent)x).collect(Collectors.toList()));
    }

    @Override
    public void addParameter(String name, IBase value) {
        if (!(value instanceof DataType)) {
            throw new IllegalArgumentException("element passed as value argument is not a valid data type");
        }
        this.getParameters().addParameter(name, (DataType)value);
    }

    @Override
    public void addParameter(String name, IBaseResource resource) {
        if (!(resource instanceof Resource)) {
            throw new IllegalArgumentException("element passed as value argument is not a valid data type");
        }
        this.getParameters().addParameter().setName(name).setResource((Resource)resource);
    }

    @Override
    public void addParameter(IBase parameter) {
        if (!(parameter instanceof Parameters.ParametersParameterComponent)) {
            throw new IllegalArgumentException("element passed as parameter argument is not a valid parameter component");
        }
        this.getParameters().addParameter((Parameters.ParametersParameterComponent)parameter);
    }

    public Parameters.ParametersParameterComponent addParameter() {
        return this.getParameters().addParameter();
    }
}

