/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.adapter.r5;

import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.opencds.cqf.fhir.utility.adapter.DependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.IStructureDefinitionAdapter;
import org.opencds.cqf.fhir.utility.adapter.r5.ResourceAdapter;

public class StructureDefinitionAdapter
extends ResourceAdapter
implements IStructureDefinitionAdapter {
    public StructureDefinitionAdapter(IDomainResource structureDefinition) {
        super((IBaseResource)structureDefinition);
        if (!(structureDefinition instanceof StructureDefinition)) {
            throw new IllegalArgumentException("resource passed as planDefinition argument is not a StructureDefinition resource");
        }
    }

    public StructureDefinitionAdapter(StructureDefinition structureDefinition) {
        super((IBaseResource)structureDefinition);
    }

    protected StructureDefinition getStructureDefinition() {
        return (StructureDefinition)this.resource;
    }

    @Override
    public List<IDependencyInfo> getDependencies() {
        ArrayList<IDependencyInfo> references = new ArrayList<IDependencyInfo>();
        String referenceSource = this.getReferenceSource();
        this.addProfileReferences(references, referenceSource);
        if (this.get().hasBaseDefinition()) {
            references.add(new DependencyInfo(referenceSource, this.get().getBaseDefinition(), this.get().getBaseDefinitionElement().getExtension(), reference -> this.get().setBaseDefinition(reference)));
        }
        this.get().getExtensionsByUrl("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-assertionExpression").stream().filter(e -> e.getValue() instanceof Expression).map(e -> (Expression)e.getValue()).filter(e -> e.hasReference()).forEach(expression -> references.add(new DependencyInfo(referenceSource, expression.getReference(), expression.getExtension(), arg_0 -> ((Expression)expression).setReference(arg_0))));
        this.get().getExtensionsByUrl("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-featureExpression").stream().filter(e -> e.getValue() instanceof Expression).map(e -> (Expression)e.getValue()).filter(e -> e.hasReference()).forEach(expression -> references.add(new DependencyInfo(referenceSource, expression.getReference(), expression.getExtension(), arg_0 -> ((Expression)expression).setReference(arg_0))));
        this.get().getExtensionsByUrl("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-inferenceExpression").stream().filter(e -> e.getValue() instanceof Expression).map(e -> (Expression)e.getValue()).filter(e -> e.hasReference()).forEach(expression -> references.add(new DependencyInfo(referenceSource, expression.getReference(), expression.getExtension(), arg_0 -> ((Expression)expression).setReference(arg_0))));
        this.get().getDifferential().getElement().forEach(element -> this.getDependenciesOfDifferential((ElementDefinition)element, (List<IDependencyInfo>)references, referenceSource));
        return references;
    }

    private void getDependenciesOfDifferential(ElementDefinition element, List<IDependencyInfo> references, String referenceSource) {
        element.getType().forEach(type -> {
            type.getProfile().forEach(profile -> references.add(new DependencyInfo(referenceSource, profile.getValueAsString(), profile.getExtension(), arg_0 -> ((CanonicalType)profile).setValue(arg_0))));
            type.getTargetProfile().forEach(profile -> references.add(new DependencyInfo(referenceSource, profile.getValueAsString(), profile.getExtension(), arg_0 -> ((CanonicalType)profile).setValue(arg_0))));
        });
        if (element.getBinding().hasValueSet()) {
            references.add(new DependencyInfo(referenceSource, element.getBinding().getValueSet(), element.getBinding().getExtension(), reference -> element.getBinding().setValueSet(reference)));
        }
    }

    @Override
    public StructureDefinition get() {
        return this.getStructureDefinition();
    }

    public StructureDefinition copy() {
        return this.get().copy();
    }

    @Override
    public String getUrl() {
        return this.get().getUrl();
    }

    @Override
    public boolean hasUrl() {
        return this.get().hasUrl();
    }

    @Override
    public void setUrl(String url) {
        this.get().setUrl(url);
    }

    @Override
    public void setVersion(String version) {
        this.get().setVersion(version);
    }

    @Override
    public String getVersion() {
        return this.get().getVersion();
    }

    @Override
    public boolean hasVersion() {
        return this.get().hasVersion();
    }

    @Override
    public String getName() {
        return this.get().getName();
    }

    @Override
    public void setName(String name) {
        this.get().setName(name);
    }

    @Override
    public Date getApprovalDate() {
        return null;
    }

    @Override
    public Date getDate() {
        return this.get().getDate();
    }

    @Override
    public void setDate(Date approvalDate) {
        this.get().setDate(approvalDate);
    }

    @Override
    public void setDateElement(IPrimitiveType<Date> date) {
        if (date != null && !(date instanceof DateTimeType)) {
            throw new UnprocessableEntityException("Date must be " + DateTimeType.class.getName());
        }
        this.get().setDateElement((DateTimeType)date);
    }

    @Override
    public void setApprovalDate(Date approvalDate) {
    }

    public Period getEffectivePeriod() {
        return null;
    }

    @Override
    public String getPurpose() {
        return this.get().getPurpose();
    }

    @Override
    public void setEffectivePeriod(ICompositeType effectivePeriod) {
    }

    @Override
    public boolean hasRelatedArtifact() {
        return false;
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        return new ArrayList<RelatedArtifact>();
    }

    public List<RelatedArtifact> getRelatedArtifactsOfType(String codeString) {
        return new ArrayList<RelatedArtifact>();
    }

    @Override
    public <T extends ICompositeType & IBaseHasExtensions> void setRelatedArtifact(List<T> relatedArtifacts) throws UnprocessableEntityException {
    }

    @Override
    public void setStatus(String statusCodeString) {
        Enumerations.PublicationStatus status;
        try {
            status = Enumerations.PublicationStatus.fromCode((String)statusCodeString);
        }
        catch (FHIRException e) {
            throw new UnprocessableEntityException("Invalid status code");
        }
        this.get().setStatus(status);
    }

    @Override
    public String getStatus() {
        return this.get().getStatus() == null ? null : this.get().getStatus().toCode();
    }

    @Override
    public boolean getExperimental() {
        return this.get().getExperimental();
    }
}

