/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.client;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IOperationUnnamed;
import ca.uhn.fhir.rest.gclient.IQuery;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseEnumFactory;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r5.model.Enumerations;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.Parameters;
import org.opencds.cqf.fhir.utility.adapter.EndpointAdapter;
import org.opencds.cqf.fhir.utility.adapter.KnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.ParametersAdapter;
import org.opencds.cqf.fhir.utility.adapter.ValueSetAdapter;
import org.opencds.cqf.fhir.utility.client.Clients;
import org.opencds.cqf.fhir.utility.search.Searches;

public class TerminologyServerClient {
    private final FhirContext ctx;
    public static final String versionParamName = "valueSetVersion";
    public static final String urlParamName = "url";

    public TerminologyServerClient(FhirContext ctx) {
        this.ctx = ctx;
    }

    public IBaseResource expand(ValueSetAdapter valueSet, EndpointAdapter endpoint, ParametersAdapter parameters) {
        Preconditions.checkNotNull((Object)valueSet, (Object)"expected non-null value for valueSet");
        Preconditions.checkNotNull((Object)endpoint, (Object)"expected non-null value for endpoint");
        Preconditions.checkNotNull((Object)parameters, (Object)"expected non-null value for parameters");
        return this.expand(endpoint, parameters, valueSet.getUrl(), valueSet.getVersion(), valueSet.get().getStructureFhirVersionEnum());
    }

    public IBaseResource expand(EndpointAdapter endpoint, ParametersAdapter parameters, FhirVersionEnum fhirVersion) {
        Preconditions.checkNotNull((Object)endpoint, (Object)"expected non-null value for endpoint");
        Preconditions.checkNotNull((Object)parameters, (Object)"expected non-null value for parameters");
        Preconditions.checkNotNull((Object)fhirVersion, (Object)"expected non-null value for fhirVersion");
        Preconditions.checkNotNull((Object)parameters.getParameter(urlParamName), (Object)"expected non-null value for 'url' expansion parameter");
        return this.expand(endpoint, parameters, null, null, fhirVersion);
    }

    public IBaseResource expand(EndpointAdapter endpoint, ParametersAdapter parameters, String url, String valueSetVersion, FhirVersionEnum fhirVersion) {
        Preconditions.checkNotNull((Object)endpoint, (Object)"expected non-null value for endpoint");
        Preconditions.checkNotNull((Object)parameters, (Object)"expected non-null value for parameters");
        IGenericClient fhirClient = this.initializeClientWithAuth(endpoint);
        if (parameters.getParameter(urlParamName) == null) {
            if (url == null) {
                throw new UnprocessableEntityException("No 'url' expansion parameter present");
            }
            parameters.addParameter(fhirVersion == FhirVersionEnum.DSTU3 ? Parameters.newUriPart(this.ctx, urlParamName, url, new IBase[0]) : Parameters.newUrlPart(this.ctx, urlParamName, url, new IBase[0]));
        }
        if (parameters.getParameter(versionParamName) == null && valueSetVersion != null) {
            parameters.addParameter(Parameters.newStringPart(this.ctx, versionParamName, valueSetVersion, new IBase[0]));
        }
        return (IBaseResource)((IOperationUnnamed)fhirClient.operation().onType("ValueSet")).named("$expand").withParameters((IBaseParameters)parameters.get()).returnResourceType(this.getValueSetClass(fhirVersion)).execute();
    }

    private IGenericClient initializeClientWithAuth(EndpointAdapter endpoint) {
        String username = endpoint.getExtensionsByUrl("vsacUsername").stream().findFirst().map(ext -> ext.getValue().toString()).orElseThrow(() -> new UnprocessableEntityException("Cannot expand ValueSet without VSAC Username."));
        String apiKey = endpoint.getExtensionsByUrl("apiKey").stream().findFirst().map(ext -> ext.getValue().toString()).orElseThrow(() -> new UnprocessableEntityException("Cannot expand ValueSet without VSAC API Key."));
        IGenericClient fhirClient = this.ctx.newRestfulGenericClient(this.getAddressBase(endpoint.getAddress()));
        Clients.registerAdditionalRequestHeadersAuth(fhirClient, username, apiKey);
        return fhirClient;
    }

    public Optional<IDomainResource> getResource(EndpointAdapter endpoint, String url, FhirVersionEnum versionEnum) {
        return KnowledgeArtifactAdapter.findLatestVersion((IBaseBundle)((IQuery)this.initializeClientWithAuth(endpoint).search().forResource(this.getValueSetClass(versionEnum)).where(Searches.byCanonical(url))).execute());
    }

    private Class<? extends IBaseResource> getValueSetClass(FhirVersionEnum fhirVersion) {
        switch (fhirVersion) {
            case DSTU3: {
                return ValueSet.class;
            }
            case R4: {
                return org.hl7.fhir.r4.model.ValueSet.class;
            }
            case R5: {
                return org.hl7.fhir.r5.model.ValueSet.class;
            }
        }
        throw new UnprocessableEntityException("Unknown ValueSet version");
    }

    private String getAddressBase(String address) {
        return TerminologyServerClient.getAddressBase(address, this.ctx);
    }

    public static String getAddressBase(String address, FhirContext ctx) {
        String maybeFhirType;
        Objects.requireNonNull(address, "address must not be null");
        if (address.startsWith("http://")) {
            address = address.replaceFirst("http://", "https://");
        }
        if (address.endsWith("/")) {
            address = address.substring(0, address.length() - 1);
        }
        if ((maybeFhirType = Canonicals.getResourceType(address)) != null && StringUtils.isNotBlank((CharSequence)maybeFhirType)) {
            IBaseEnumFactory<?> factory = TerminologyServerClient.getEnumFactory(ctx);
            try {
                factory.fromCode(maybeFhirType);
            }
            catch (IllegalArgumentException e) {
                int lastSlashIndex = address.lastIndexOf("/");
                if (lastSlashIndex > 0) {
                    maybeFhirType = address.substring(lastSlashIndex + 1, address.length());
                    try {
                        factory.fromCode(maybeFhirType);
                    }
                    catch (IllegalArgumentException e2) {
                        return address;
                    }
                }
                return address;
            }
            address = address.substring(0, address.indexOf(maybeFhirType) - 1);
        }
        return address;
    }

    public static IBaseEnumFactory<?> getEnumFactory(FhirContext ctx) {
        switch (ctx.getVersion().getVersion()) {
            case DSTU3: {
                return new Enumerations.ResourceTypeEnumFactory();
            }
            case R4: {
                return new Enumerations.ResourceTypeEnumFactory();
            }
            case R5: {
                return new Enumerations.ResourceTypeEnumEnumFactory();
            }
        }
        throw new UnprocessableEntityException("unsupported FHIR version: " + ctx.getVersion().getVersion().toString());
    }
}

