/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.iterable;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.bundle.BundleEntryParts;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.opencds.cqf.fhir.api.Repository;

public class BundleIterator<B extends IBaseBundle>
implements Iterator<BundleEntryParts> {
    protected final Repository repository;
    protected B bundle;
    protected int index = 0;
    protected List<BundleEntryParts> parts;

    public BundleIterator(Repository repository, B bundle) {
        this.repository = repository;
        this.bundle = bundle;
        this.parts = BundleUtil.toListOfEntries((FhirContext)repository.fhirContext(), bundle);
    }

    @Override
    public boolean hasNext() {
        return this.parts.size() > this.index;
    }

    @Override
    public BundleEntryParts next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        BundleEntryParts next = this.parts.get(this.index);
        ++this.index;
        if (this.index >= this.parts.size()) {
            this.getNextBundle();
        }
        return next;
    }

    protected void getNextBundle() {
        this.index = 0;
        String nextLink = BundleUtil.getLinkUrlOfType((FhirContext)this.repository.fhirContext(), this.bundle, (String)"next");
        if (nextLink == null) {
            this.parts = Collections.emptyList();
            return;
        }
        Class clazz = this.bundle.getClass();
        this.bundle = this.repository.link(clazz, nextLink);
        if (this.bundle == null) {
            this.parts = Collections.emptyList();
            return;
        }
        this.parts = BundleUtil.toListOfEntries((FhirContext)this.repository.fhirContext(), this.bundle);
        if (this.parts.isEmpty()) {
            this.getNextBundle();
        }
    }
}

