/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.operation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.ParametersUtil;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.utility.Parameters;
import org.opencds.cqf.fhir.utility.Resources;
import org.opencds.cqf.fhir.utility.operation.ExtraParams;

interface ParameterBinder {
    public Object bind(IBaseParameters var1);

    @Nonnull
    public Type type();

    @Nonnull
    public String name();

    @Nonnull
    public Parameter parameter();

    public static List<ParameterBinder> validate(List<ParameterBinder> parameterBinders) {
        long idParamCount = parameterBinders.stream().filter(x -> x.type() == Type.ID).count();
        if (idParamCount > 1L) {
            throw new IllegalArgumentException("Method cannot have more than one @IdParam");
        }
        if (idParamCount > 0L && parameterBinders.get(0).type() != Type.ID) {
            throw new IllegalArgumentException("If @IdParam is present, it must be the first parameter");
        }
        long extraParamCount = parameterBinders.stream().filter(x -> x.type() == Type.EXTRA).count();
        if (extraParamCount > 1L) {
            throw new IllegalArgumentException("Method cannot have more than one @ExtraParams");
        }
        if (extraParamCount > 0L && parameterBinders.get(parameterBinders.size() - 1).type() != Type.EXTRA) {
            throw new IllegalArgumentException("If @ExtraParams is present, it must be the last parameter");
        }
        return parameterBinders;
    }

    public static ParameterBinder from(Parameter parameter) {
        Objects.requireNonNull(parameter, "parameter can not be null");
        IdParam idParam = parameter.getAnnotation(IdParam.class);
        OperationParam operationParam = parameter.getAnnotation(OperationParam.class);
        ExtraParams extraParam = parameter.getAnnotation(ExtraParams.class);
        ParameterBinder.ensureExactlyOneOf(idParam, operationParam, extraParam);
        if (idParam != null) {
            return new IdParameterBinder(parameter);
        }
        if (operationParam != null) {
            return new OperationParameterBinder(parameter, operationParam);
        }
        return new ExtraParamBinder(parameter);
    }

    public static void ensureExactlyOneOf(IdParam idParam, OperationParam operationParam, ExtraParams extraParams) {
        long count = Arrays.asList(idParam, operationParam, extraParams).stream().filter(Objects::nonNull).count();
        if (count == 0L) {
            throw new IllegalArgumentException("Method Parameter must be annotated with @IdParam, @OperationParam, or @ExtraParams");
        }
        if (count > 1L) {
            throw new IllegalArgumentException("Method Parameter can only be annotated with one of @IdParam, @OperationParam, or @ExtraParams");
        }
    }

    public static enum Type {
        ID,
        OPERATION,
        EXTRA;

    }

    public static class IdParameterBinder
    implements ParameterBinder {
        private final Parameter parameter;

        public IdParameterBinder(Parameter parameter) {
            this.parameter = Objects.requireNonNull(parameter, "parameter can not be null");
            Preconditions.checkArgument((boolean)IIdType.class.isAssignableFrom(parameter.getType()), (Object)"Parameter annotated with @IdParam must be of type IIdType");
        }

        @Override
        public Type type() {
            return Type.ID;
        }

        @Override
        public String name() {
            return "_id";
        }

        @Override
        public Object bind(IBaseParameters parameters) {
            throw new UnsupportedOperationException("bind is not supported for @IdParam");
        }

        @Override
        public Parameter parameter() {
            return this.parameter;
        }
    }

    public static class OperationParameterBinder
    implements ParameterBinder {
        private final Parameter parameter;
        private final OperationParam operationParam;
        private final ParameterClass parameterClass;

        public OperationParameterBinder(Parameter parameter, OperationParam operationParam) {
            this.parameter = Objects.requireNonNull(parameter, "parameter can not be null");
            this.operationParam = Objects.requireNonNull(operationParam, "operationParam can not be null");
            Objects.requireNonNull(operationParam.name(), "@OperationParam must have a name defined");
            this.parameterClass = OperationParameterBinder.determineParameterClass(parameter);
        }

        private static ParameterClass determineParameterClass(Parameter parameter) {
            Class<?> type = parameter.getType();
            if (IBaseResource.class.isAssignableFrom(type)) {
                return ParameterClass.RESOURCE;
            }
            if (IBaseDatatype.class.isAssignableFrom(type)) {
                return ParameterClass.VALUE;
            }
            if (List.class.isAssignableFrom(type)) {
                return ParameterClass.LIST;
            }
            throw new IllegalArgumentException("Parameter annotated with @Operation must be a FHIR type or a List");
        }

        @Override
        public Type type() {
            return Type.OPERATION;
        }

        @Override
        public String name() {
            return this.operationParam.name();
        }

        @Override
        public Object bind(IBaseParameters parameters) {
            IBaseResource returnValue;
            if (parameters == null && this.operationParam.min() <= 0) {
                return null;
            }
            if (parameters == null) {
                throw new IllegalArgumentException("Parameter " + this.name() + " is required but was not provided");
            }
            FhirContext context = parameters.getStructureFhirVersionEnum().newContextCached();
            FhirTerser terser = context.newTerser();
            List params = ParametersUtil.getNamedParameters((FhirContext)context, (IBaseResource)parameters, (String)this.name());
            Parameters.removeParameter(parameters, this.name());
            if (params.isEmpty() && this.operationParam.min() > 0) {
                throw new IllegalArgumentException("Parameter " + this.name() + " is required but was not provided");
            }
            if (params.size() > 1) {
                throw new IllegalArgumentException("Parameter " + this.name() + " has more than one value. Use parameter parts for multiple values");
            }
            if (params.isEmpty()) {
                return null;
            }
            List parts = terser.getValues((IBase)params.get(0), "part");
            if (this.parameterClass != ParameterClass.LIST && !parts.isEmpty()) {
                throw new IllegalArgumentException("Parameter " + this.name() + " is not the expected type " + String.valueOf(this.parameter.getType()));
            }
            if (this.parameterClass == ParameterClass.LIST) {
                int size = parts.size();
                if (this.operationParam.min() > size) {
                    throw new IllegalArgumentException("Parameter " + this.name() + " has fewer values than the minimum of " + this.operationParam.min());
                }
                if (this.operationParam.max() > 0 && size > this.operationParam.max()) {
                    throw new IllegalArgumentException("Parameter " + this.name() + " has more values than the maximum of " + this.operationParam.max());
                }
            }
            if (this.parameterClass == ParameterClass.LIST) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (IBase part : parts) {
                    IBaseResource r = (IBaseResource)terser.getSingleValueOrNull(part, "resource", IBaseResource.class);
                    IBase v = terser.getSingleValueOrNull(part, "value[x]", IBase.class);
                    if (v != null) {
                        values.add(v);
                        continue;
                    }
                    if (r != null) {
                        values.add(r);
                        continue;
                    }
                    throw new IllegalArgumentException("Parameter " + this.name() + " has an empty part. Expected a resource or value[x]");
                }
                return values;
            }
            IBase param = (IBase)params.get(0);
            IBaseResource valueResource = (IBaseResource)terser.getSingleValueOrNull(param, "resource", IBaseResource.class);
            IBase value = terser.getSingleValueOrNull(param, "value[x]", IBase.class);
            if (valueResource != null && value != null) {
                throw new IllegalArgumentException("Parameter " + this.name() + " has both a resource and a value. Only one is allowed");
            }
            if (this.parameterClass == ParameterClass.RESOURCE) {
                if (value != null) {
                    throw new IllegalArgumentException("Parameter " + this.name() + " is not the expected type " + String.valueOf(this.parameter.getType()));
                }
                if (valueResource == null && this.operationParam.min() > 0) {
                    throw new IllegalArgumentException("Parameter " + this.name() + " is required but was not provided");
                }
            }
            if (this.parameterClass == ParameterClass.VALUE) {
                if (valueResource != null) {
                    throw new IllegalArgumentException("Parameter " + this.name() + " is not the expected type " + String.valueOf(this.parameter.getType()));
                }
                if (value == null && this.operationParam.min() > 0) {
                    throw new IllegalArgumentException("Parameter " + this.name() + " is required but was not provided");
                }
            }
            Object object = returnValue = valueResource != null ? valueResource : value;
            if (returnValue == null) {
                return null;
            }
            try {
                return this.parameter.getType().cast(returnValue);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Parameter value '" + this.name() + "'' is not of the expected type " + String.valueOf(this.parameter.getType()));
            }
        }

        @Override
        public Parameter parameter() {
            return this.parameter;
        }

        private static enum ParameterClass {
            RESOURCE,
            VALUE,
            LIST;

        }
    }

    public static class ExtraParamBinder
    implements ParameterBinder {
        private final Parameter parameter;

        public ExtraParamBinder(Parameter parameter) {
            this.parameter = Objects.requireNonNull(parameter, "parameter can not be null");
            Preconditions.checkArgument((boolean)IBaseParameters.class.isAssignableFrom(parameter.getType()), (Object)"Parameter annotated with @ExtraParams must be of type IBaseParameters");
        }

        @Override
        public Type type() {
            return Type.EXTRA;
        }

        @Override
        public String name() {
            return "<extra>";
        }

        @Override
        public Object bind(IBaseParameters parameters) {
            if (parameters == null) {
                return null;
            }
            IBaseParameters value = Resources.clone(parameters);
            return value;
        }

        @Override
        public Parameter parameter() {
            return this.parameter;
        }
    }
}

