/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.r5;

import java.util.Arrays;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.Resource;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.adapter.AdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.KnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.r5.SearchHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageHelper
extends org.opencds.cqf.fhir.utility.PackageHelper {
    protected static final Logger logger = LoggerFactory.getLogger(PackageHelper.class);
    protected static final List<String> PACKABLE_RESOURCES = Arrays.asList(Enumerations.FHIRTypes.LIBRARY.toCode(), Enumerations.FHIRTypes.PLANDEFINITION.toCode(), Enumerations.FHIRTypes.ACTIVITYDEFINITION.toCode(), Enumerations.FHIRTypes.STRUCTUREDEFINITION.toCode(), Enumerations.FHIRTypes.CODESYSTEM.toCode(), Enumerations.FHIRTypes.VALUESET.toCode());

    private PackageHelper() {
    }

    public static void addRelatedArtifacts(IBaseBundle bundle, List<RelatedArtifact> artifacts, Repository repository, boolean isPut) {
        for (RelatedArtifact artifact : artifacts) {
            if (!artifact.getType().equals((Object)RelatedArtifact.RelatedArtifactType.DEPENDSON) || !artifact.hasResourceElement()) continue;
            try {
                Resource resource;
                CanonicalType canonical = artifact.getResourceElement();
                if (!PACKABLE_RESOURCES.contains(Canonicals.getResourceType(canonical)) || (resource = SearchHelper.searchRepositoryByCanonical(repository, canonical)) == null || !BundleHelper.getEntryResources(bundle).stream().noneMatch(r -> r.getIdElement().equals((Object)resource.getIdElement()))) continue;
                BundleHelper.addEntry(bundle, PackageHelper.createEntry((IBaseResource)resource, isPut));
                KnowledgeArtifactAdapter adapter = AdapterFactory.forFhirVersion(resource.getStructureFhirVersionEnum()).createKnowledgeArtifactAdapter((IDomainResource)resource);
                if (!adapter.hasRelatedArtifact()) continue;
                PackageHelper.addRelatedArtifacts(bundle, adapter.getRelatedArtifact(), repository, isPut);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

