/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.visitor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.server.exceptions.NotImplementedOperationException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBooleanDatatype;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseIntegerDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.Bundle;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.ExpandHelper;
import org.opencds.cqf.fhir.utility.PackageHelper;
import org.opencds.cqf.fhir.utility.Parameters;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.opencds.cqf.fhir.utility.adapter.AdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.EndpointAdapter;
import org.opencds.cqf.fhir.utility.adapter.IDependencyInfo;
import org.opencds.cqf.fhir.utility.adapter.KnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.adapter.LibraryAdapter;
import org.opencds.cqf.fhir.utility.adapter.ParametersAdapter;
import org.opencds.cqf.fhir.utility.adapter.ValueSetAdapter;
import org.opencds.cqf.fhir.utility.client.TerminologyServerClient;
import org.opencds.cqf.fhir.utility.visitor.IKnowledgeArtifactVisitor;
import org.opencds.cqf.fhir.utility.visitor.VisitorHelper;

public class PackageVisitor
implements IKnowledgeArtifactVisitor {
    protected final FhirContext fhirContext;
    protected final TerminologyServerClient terminologyServerClient;
    protected final ExpandHelper expandHelper;

    public PackageVisitor(FhirContext fhirContext) {
        this.fhirContext = fhirContext;
        this.terminologyServerClient = new TerminologyServerClient(this.fhirContext);
        this.expandHelper = new ExpandHelper(fhirContext, this.terminologyServerClient);
    }

    @Override
    public IBase visit(KnowledgeArtifactAdapter adapter, Repository repository, IBaseParameters packageParameters) {
        FhirVersionEnum fhirVersion = adapter.get().getStructureFhirVersionEnum();
        Optional<String> artifactRoute = VisitorHelper.getParameter("artifactRoute", packageParameters, IPrimitiveType.class).map(r -> (String)r.getValue());
        Optional<String> endpointUri = VisitorHelper.getParameter("endpointUri", packageParameters, IPrimitiveType.class).map(r -> (String)r.getValue());
        Optional<IBaseResource> endpoint = VisitorHelper.getResourceParameter("endpoint", packageParameters, IBaseResource.class);
        Optional<IBaseResource> terminologyEndpoint = VisitorHelper.getResourceParameter("terminologyEndpoint", packageParameters, IBaseResource.class);
        Optional<Boolean> packageOnly = VisitorHelper.getParameter("packageOnly", packageParameters, IBaseBooleanDatatype.class).map(r -> (Boolean)r.getValue());
        Optional<Integer> count = VisitorHelper.getParameter("count", packageParameters, IBaseIntegerDatatype.class).map(r -> (Integer)r.getValue());
        Optional<Integer> offset = VisitorHelper.getParameter("offset", packageParameters, IBaseIntegerDatatype.class).map(r -> (Integer)r.getValue());
        List include = VisitorHelper.getListParameter("include", packageParameters, IPrimitiveType.class).map(list -> list.stream().map(r -> (String)r.getValue()).collect(Collectors.toList())).orElseGet(() -> new ArrayList());
        List capability = VisitorHelper.getListParameter("capability", packageParameters, IPrimitiveType.class).map(list -> list.stream().map(r -> (String)r.getValue()).collect(Collectors.toList())).orElseGet(() -> new ArrayList());
        List artifactVersion = VisitorHelper.getListParameter("artifactVersion", packageParameters, IPrimitiveType.class).map(l -> l.stream().map(t -> (String)t.getValue()).collect(Collectors.toList())).orElseGet(() -> new ArrayList());
        List checkArtifactVersion = VisitorHelper.getListParameter("checkArtifactVersion", packageParameters, IPrimitiveType.class).map(l -> l.stream().map(t -> (String)t.getValue()).collect(Collectors.toList())).orElseGet(() -> new ArrayList());
        List forceArtifactVersion = VisitorHelper.getListParameter("forceArtifactVersion", packageParameters, IPrimitiveType.class).map(l -> l.stream().map(t -> (String)t.getValue()).collect(Collectors.toList())).orElseGet(() -> new ArrayList());
        boolean isPut = VisitorHelper.getParameter("isPut", packageParameters, IBaseBooleanDatatype.class).map(r -> (Boolean)r.getValue()).orElse(false);
        if (artifactRoute.isPresent() && !StringUtils.isBlank((CharSequence)artifactRoute.get()) && !artifactRoute.get().isEmpty() || endpointUri.isPresent() && !StringUtils.isBlank((CharSequence)endpointUri.get()) && !endpointUri.get().isEmpty() || endpoint.isPresent()) {
            throw new NotImplementedOperationException("This repository is not implementing custom Content and endpoints at this time");
        }
        if (packageOnly.isPresent()) {
            throw new NotImplementedOperationException("This repository is not implementing packageOnly at this time");
        }
        if (count.isPresent() && count.get() < 0) {
            throw new UnprocessableEntityException("'count' must be non-negative");
        }
        IDomainResource resource = adapter.get();
        HashSet<String> packagedResources = new HashSet<String>();
        IBaseBundle packagedBundle = BundleHelper.newBundle(fhirVersion);
        if (include.size() == 1 && include.stream().anyMatch(includedType -> includedType.equals("artifact"))) {
            VisitorHelper.findUnsupportedCapability(adapter, capability);
            VisitorHelper.processCanonicals(adapter, artifactVersion, checkArtifactVersion, forceArtifactVersion);
            IBaseBackboneElement entry = PackageHelper.createEntry((IBaseResource)resource, isPut);
            BundleHelper.addEntry(packagedBundle, entry);
        } else {
            this.recursivePackage(resource, packagedResources, packagedBundle, repository, capability, include, artifactVersion, checkArtifactVersion, forceArtifactVersion, isPut);
            List<? extends IBaseBackboneElement> included = this.findUnsupportedInclude(BundleHelper.getEntry(packagedBundle), include, fhirVersion);
            BundleHelper.setEntry(packagedBundle, included);
        }
        this.handleValueSets(resource, packagedBundle, repository, terminologyEndpoint);
        this.setCorrectBundleType(count, offset, packagedBundle, fhirVersion);
        this.pageBundleBasedOnCountAndOffset(count, offset, packagedBundle);
        return packagedBundle;
    }

    protected void handleValueSets(IDomainResource resource, IBaseBundle packagedBundle, Repository repository, Optional<IBaseResource> terminologyEndpoint) {
        IBaseExtension<?, ?> expansionParamsExtension;
        IBaseParameters expansionParams = Parameters.newParameters(repository.fhirContext(), new IBase[0]);
        LibraryAdapter rootSpecificationLibrary = PackageVisitor.getRootSpecificationLibrary(packagedBundle);
        if (rootSpecificationLibrary != null && (expansionParamsExtension = rootSpecificationLibrary.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/cqf-expansionParameters")) != null && expansionParamsExtension.getValue() != null) {
            expansionParams = PackageVisitor.getExpansionParams(rootSpecificationLibrary, ((IBaseReference)expansionParamsExtension.getValue()).getReferenceElement().getValueAsString());
        }
        ParametersAdapter params = (ParametersAdapter)AdapterFactory.createAdapterForResource((IBaseResource)expansionParams);
        ArrayList expandedList = new ArrayList();
        List valueSets = BundleHelper.getEntryResources(packagedBundle).stream().filter(r -> r.fhirType().equals("ValueSet")).map(v -> (ValueSetAdapter)AdapterFactory.createAdapterForResource(v)).collect(Collectors.toList());
        valueSets.stream().forEach(valueSet -> this.expandHelper.expandValueSet((ValueSetAdapter)valueSet, params, terminologyEndpoint.map(e -> (EndpointAdapter)AdapterFactory.createAdapterForResource(e)), valueSets, expandedList, repository, new Date()));
    }

    protected void recursivePackage(IDomainResource resource, Set<String> packagedResources, IBaseBundle bundle, Repository repository, List<String> capability, List<String> include, List<String> artifactVersion, List<String> checkArtifactVersion, List<String> forceArtifactVersion, boolean isPut) throws PreconditionFailedException {
        if (resource == null) {
            return;
        }
        FhirVersionEnum fhirVersion = resource.getStructureFhirVersionEnum();
        KnowledgeArtifactAdapter adapter = AdapterFactory.forFhirVersion(fhirVersion).createKnowledgeArtifactAdapter(resource);
        if (!packagedResources.contains(adapter.getCanonical())) {
            packagedResources.add(adapter.getCanonical());
            VisitorHelper.findUnsupportedCapability(adapter, capability);
            VisitorHelper.processCanonicals(adapter, artifactVersion, checkArtifactVersion, forceArtifactVersion);
            boolean entryExists = BundleHelper.getEntryResources(bundle).stream().map(e -> AdapterFactory.forFhirVersion(fhirVersion).createKnowledgeArtifactAdapter((IDomainResource)e)).filter(mr -> mr.getUrl() != null).anyMatch(mr -> mr.getUrl().equals(adapter.getUrl()) && (!mr.hasVersion() || mr.getVersion().equals(adapter.getVersion())));
            if (!entryExists) {
                IBaseBackboneElement entry = PackageHelper.createEntry((IBaseResource)resource, isPut);
                BundleHelper.addEntry(bundle, entry);
            }
            List<IDependencyInfo> dependencies = adapter.combineComponentsAndDependencies();
            dependencies.stream().filter(ra -> {
                try {
                    return null != repository.fhirContext().getResourceDefinition(Canonicals.getResourceType(ra.getReference()));
                }
                catch (Exception e) {
                    return false;
                }
            }).map(ra -> SearchHelper.searchRepositoryByCanonicalWithPaging(repository, ra.getReference())).map(searchBundle -> (IDomainResource)BundleHelper.getEntryResourceFirstRep(searchBundle)).forEach(component -> this.recursivePackage((IDomainResource)component, packagedResources, bundle, repository, capability, include, artifactVersion, checkArtifactVersion, forceArtifactVersion, isPut));
        }
    }

    protected void setCorrectBundleType(Optional<Integer> count, Optional<Integer> offset, IBaseBundle bundle, FhirVersionEnum fhirVersion) {
        switch (fhirVersion) {
            case DSTU3: {
                org.opencds.cqf.fhir.utility.visitor.dstu3.PackageVisitor.setCorrectBundleType(count, offset, (org.hl7.fhir.dstu3.model.Bundle)bundle);
                break;
            }
            case R4: {
                org.opencds.cqf.fhir.utility.visitor.r4.PackageVisitor.setCorrectBundleType(count, offset, (org.hl7.fhir.r4.model.Bundle)bundle);
                break;
            }
            case R5: {
                org.opencds.cqf.fhir.utility.visitor.r5.PackageVisitor.setCorrectBundleType(count, offset, (Bundle)bundle);
                break;
            }
            default: {
                throw new UnprocessableEntityException(String.format("Unsupported version of FHIR: %s", fhirVersion.getFhirVersionString()));
            }
        }
    }

    protected void pageBundleBasedOnCountAndOffset(Optional<Integer> count, Optional<Integer> offset, IBaseBundle bundle) {
        Integer bundleSize;
        List<? extends IBaseBackboneElement> entries;
        if (offset.isPresent()) {
            entries = BundleHelper.getEntry(bundle);
            bundleSize = entries.size();
            if (offset.get() < bundleSize) {
                BundleHelper.setEntry(bundle, entries.subList(offset.get(), bundleSize));
            } else {
                BundleHelper.setEntry(bundle, Arrays.asList(new IBaseBackboneElement[0]));
            }
        }
        if (count.isPresent()) {
            entries = BundleHelper.getEntry(bundle);
            bundleSize = entries.size();
            if (count.get() < bundleSize) {
                BundleHelper.setEntry(bundle, entries.subList(0, count.get()));
            }
        }
    }

    protected List<? extends IBaseBackboneElement> findUnsupportedInclude(List<? extends IBaseBackboneElement> entries, List<String> include, FhirVersionEnum fhirVersion) {
        switch (fhirVersion) {
            case DSTU3: {
                return org.opencds.cqf.fhir.utility.visitor.dstu3.PackageVisitor.findUnsupportedInclude(entries, include);
            }
            case R4: {
                return org.opencds.cqf.fhir.utility.visitor.r4.PackageVisitor.findUnsupportedInclude(entries, include);
            }
            case R5: {
                return org.opencds.cqf.fhir.utility.visitor.r5.PackageVisitor.findUnsupportedInclude(entries, include);
            }
        }
        throw new UnprocessableEntityException(String.format("Unsupported version of FHIR: %s", fhirVersion.getFhirVersionString()));
    }

    protected static LibraryAdapter getRootSpecificationLibrary(IBaseBundle bundle) {
        Optional<LibraryAdapter> rootSpecLibrary = BundleHelper.getEntryResources(bundle).stream().filter(r -> r.fhirType().equals("Library")).map(r -> AdapterFactory.forFhirVersion(r.getStructureFhirVersionEnum()).createLibrary((IBaseResource)r)).findFirst();
        return rootSpecLibrary.orElse(null);
    }

    protected static IBaseParameters getExpansionParams(LibraryAdapter rootSpecificationLibrary, String reference) {
        Optional<IBaseResource> expansionParamResource = rootSpecificationLibrary.getContained().stream().filter(contained -> contained.getIdElement().getValue().equals(reference)).findFirst();
        return expansionParamResource.orElse(null);
    }
}

