/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility.visitor;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.PackageHelper;
import org.opencds.cqf.fhir.utility.adapter.AdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.KnowledgeArtifactAdapter;
import org.opencds.cqf.fhir.utility.visitor.AbstractKnowledgeArtifactVisitor;

public class RetireVisitor
extends AbstractKnowledgeArtifactVisitor {
    @Override
    public IBase visit(KnowledgeArtifactAdapter rootAdapter, Repository repository, IBaseParameters operationParameters) {
        if (!rootAdapter.getStatus().equals("active")) {
            throw new PreconditionFailedException("Cannot retire an artifact that is not in active status");
        }
        FhirVersionEnum fhirVersion = rootAdapter.get().getStructureFhirVersionEnum();
        IBaseBundle transactionBundle = BundleHelper.newBundle(fhirVersion, null, "transaction");
        ArrayList<IDomainResource> resToUpdate = new ArrayList<IDomainResource>();
        resToUpdate.add(rootAdapter.get());
        List<IDomainResource> resourcesToUpdate = this.getComponents(rootAdapter, repository, resToUpdate);
        Date nowDate = new Date();
        for (IDomainResource resource : resourcesToUpdate) {
            KnowledgeArtifactAdapter artifact = AdapterFactory.forFhirVersion(resource.getStructureFhirVersionEnum()).createKnowledgeArtifactAdapter(resource);
            RetireVisitor.updateMetadata(artifact, nowDate);
            IBaseBackboneElement entry = PackageHelper.createEntry((IBaseResource)artifact.get(), true);
            BundleHelper.addEntry(transactionBundle, entry);
        }
        return repository.transaction(transactionBundle);
    }

    private static void updateMetadata(KnowledgeArtifactAdapter artifactAdapter, Date date) {
        artifactAdapter.setDate(date);
        artifactAdapter.setStatus("retired");
    }
}

