/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class Canonicals {
    private Canonicals() {
    }

    public static <CanonicalType extends IPrimitiveType<String>> String getResourceType(CanonicalType canonicalType) {
        Preconditions.checkNotNull(canonicalType);
        Preconditions.checkArgument((boolean)canonicalType.hasValue());
        return Canonicals.getResourceType((String)canonicalType.getValue());
    }

    public static String getResourceType(String canonical) {
        Preconditions.checkNotNull((Object)canonical);
        if (!canonical.contains("/")) {
            return null;
        }
        return (canonical = canonical.replace(canonical.substring(canonical.lastIndexOf("/")), "")).contains("/") ? canonical.substring(canonical.lastIndexOf("/") + 1) : canonical;
    }

    public static <CanonicalType extends IPrimitiveType<String>> String getIdPart(CanonicalType canonicalType) {
        Preconditions.checkNotNull(canonicalType);
        Preconditions.checkArgument((boolean)canonicalType.hasValue());
        return Canonicals.getIdPart((String)canonicalType.getValue());
    }

    public static String getIdPart(String canonical) {
        Preconditions.checkNotNull((Object)canonical);
        if (!canonical.contains("/")) {
            return null;
        }
        int lastIndex = Canonicals.calculateLastIndex(canonical);
        return canonical.substring(canonical.lastIndexOf("/") + 1, lastIndex);
    }

    public static <CanonicalType extends IPrimitiveType<String>> String getVersion(CanonicalType canonicalType) {
        Preconditions.checkNotNull(canonicalType);
        Preconditions.checkArgument((boolean)canonicalType.hasValue());
        return Canonicals.getVersion((String)canonicalType.getValue());
    }

    public static String getVersion(String canonical) {
        Preconditions.checkNotNull((Object)canonical);
        if (!canonical.contains("|")) {
            return null;
        }
        int lastIndex = canonical.lastIndexOf("#");
        if (lastIndex == -1) {
            lastIndex = canonical.length();
        }
        return canonical.substring(canonical.lastIndexOf("|") + 1, lastIndex);
    }

    public static <CanonicalType extends IPrimitiveType<String>> String getUrl(CanonicalType canonicalType) {
        Preconditions.checkNotNull(canonicalType);
        Preconditions.checkArgument((boolean)canonicalType.hasValue());
        return Canonicals.getUrl((String)canonicalType.getValue());
    }

    public static String getUrl(String canonical) {
        Preconditions.checkNotNull((Object)canonical);
        if (!(canonical.contains("/") || canonical.startsWith("urn:uuid") || canonical.startsWith("urn:oid"))) {
            return null;
        }
        int lastIndex = Canonicals.calculateLastIndex(canonical);
        return canonical.substring(0, lastIndex);
    }

    public static List<String> getUrls(List<String> canonicals) {
        Preconditions.checkNotNull(canonicals);
        ArrayList<String> result = new ArrayList<String>();
        canonicals.forEach(canonical -> result.add(Canonicals.getUrl(canonical)));
        return result;
    }

    public static <CanonicalType extends IPrimitiveType<String>> String getFragment(CanonicalType canonicalType) {
        Preconditions.checkNotNull(canonicalType);
        Preconditions.checkArgument((boolean)canonicalType.hasValue());
        return Canonicals.getFragment((String)canonicalType.getValue());
    }

    public static String getFragment(String canonical) {
        Preconditions.checkNotNull((Object)canonical);
        if (!canonical.contains("#")) {
            return null;
        }
        return canonical.substring(canonical.lastIndexOf("#") + 1);
    }

    public static <CanonicalType extends IPrimitiveType<String>> CanonicalParts getParts(CanonicalType canonicalType) {
        Preconditions.checkNotNull(canonicalType);
        Preconditions.checkArgument((boolean)canonicalType.hasValue());
        return Canonicals.getParts((String)canonicalType.getValue());
    }

    public static CanonicalParts getParts(String canonical) {
        Preconditions.checkNotNull((Object)canonical);
        String url = Canonicals.getUrl(canonical);
        String id = Canonicals.getIdPart(canonical);
        String resourceType = Canonicals.getResourceType(canonical);
        String version = Canonicals.getVersion(canonical);
        String fragment = Canonicals.getFragment(canonical);
        return new CanonicalParts(url, id, resourceType, version, fragment);
    }

    private static int calculateLastIndex(String canonical) {
        int lastIndexOfBar = canonical.lastIndexOf("|");
        int lastIndexOfHash = canonical.lastIndexOf("#");
        int lastIndex = canonical.length();
        int mul = lastIndexOfBar * lastIndexOfHash;
        if (mul > 1) {
            lastIndex = Math.min(lastIndexOfBar, lastIndexOfHash);
        } else if (mul < 0) {
            lastIndex = Math.max(lastIndexOfBar, lastIndexOfHash);
        }
        return lastIndex;
    }

    public static final class CanonicalParts {
        private final String url;
        private final String idPart;
        private final String resourceType;
        private final String version;
        private final String fragment;

        CanonicalParts(String url, String idPart, String resourceType, String version, String fragment) {
            this.url = url;
            this.idPart = idPart;
            this.resourceType = resourceType;
            this.version = version;
            this.fragment = fragment;
        }

        public String url() {
            return this.url;
        }

        public String idPart() {
            return this.idPart;
        }

        public String resourceType() {
            return this.resourceType;
        }

        public String version() {
            return this.version;
        }

        public String fragment() {
            return this.fragment;
        }
    }
}

