/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.primitive.IdDt;
import com.google.common.base.Preconditions;
import java.util.UUID;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.IdType;
import org.opencds.cqf.fhir.utility.FhirVersions;

public class Ids {
    private Ids() {
    }

    public static String ensureIdType(String id, String resourceType) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)resourceType);
        return id.contains("/") ? id : String.format("%s/%s", resourceType, id);
    }

    public static <ResourceType extends IBaseResource, IdType extends IIdType> IdType newId(Class<? extends ResourceType> resourceTypeClass, String id) {
        Preconditions.checkNotNull(resourceTypeClass);
        Preconditions.checkNotNull((Object)id);
        FhirVersionEnum versionEnum = FhirVersions.forClass(resourceTypeClass);
        return Ids.newId(versionEnum, resourceTypeClass.getSimpleName(), id);
    }

    public static <BaseType extends IBase, IdType extends IIdType> IdType newId(Class<? extends BaseType> baseTypeClass, String resourceName, String id) {
        Preconditions.checkNotNull(baseTypeClass);
        Preconditions.checkNotNull((Object)resourceName);
        Preconditions.checkNotNull((Object)id);
        FhirVersionEnum versionEnum = FhirVersions.forClass(baseTypeClass);
        return Ids.newId(versionEnum, resourceName, id);
    }

    public static <IdType extends IIdType> IdType newRandomId(FhirContext fhirContext, String resourceType) {
        Preconditions.checkNotNull((Object)fhirContext);
        Preconditions.checkNotNull((Object)resourceType);
        return Ids.newId(fhirContext.getVersion().getVersion(), resourceType, UUID.randomUUID().toString());
    }

    public static <IdType extends IIdType> IdType newId(FhirContext fhirContext, String resourceType, String id) {
        Preconditions.checkNotNull((Object)fhirContext);
        Preconditions.checkNotNull((Object)resourceType);
        Preconditions.checkNotNull((Object)id);
        return Ids.newId(fhirContext.getVersion().getVersion(), resourceType, id);
    }

    public static <IdType extends IIdType> IdType newId(FhirVersionEnum fhirVersionEnum, String resourceType, String idPart) {
        Preconditions.checkNotNull((Object)fhirVersionEnum);
        Preconditions.checkNotNull((Object)resourceType);
        Preconditions.checkNotNull((Object)idPart);
        return Ids.newId(fhirVersionEnum, resourceType + "/" + idPart);
    }

    public static <IdType extends IIdType> IdType newId(FhirContext fhirContext, String id) {
        Preconditions.checkNotNull((Object)fhirContext);
        Preconditions.checkNotNull((Object)id);
        return Ids.newId(fhirContext.getVersion().getVersion(), id);
    }

    public static String simple(IBaseResource resource) {
        Preconditions.checkNotNull((Object)resource);
        Preconditions.checkArgument((resource.getIdElement() != null ? 1 : 0) != 0);
        return Ids.simple(resource.getIdElement());
    }

    public static String simple(IIdType id) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkArgument((boolean)id.hasResourceType());
        Preconditions.checkArgument((boolean)id.hasIdPart());
        return id.toUnqualifiedVersionless().getValue();
    }

    public static String simplePart(IBaseResource resource) {
        Preconditions.checkNotNull((Object)resource);
        Preconditions.checkArgument((resource.getIdElement() != null ? 1 : 0) != 0);
        return Ids.simplePart(resource.getIdElement());
    }

    public static String simplePart(IIdType id) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkArgument((boolean)id.hasResourceType());
        Preconditions.checkArgument((boolean)id.hasIdPart());
        return id.toUnqualifiedVersionless().getIdPart();
    }

    public static <IdType extends IIdType> IdType newId(FhirVersionEnum fhirVersionEnum, String id) {
        Preconditions.checkNotNull((Object)fhirVersionEnum);
        Preconditions.checkNotNull((Object)id);
        switch (fhirVersionEnum) {
            case DSTU2: {
                return (IdType)new IdDt(id);
            }
            case DSTU2_1: {
                return (IdType)new org.hl7.fhir.dstu2016may.model.IdType(id);
            }
            case DSTU2_HL7ORG: {
                return (IdType)new org.hl7.fhir.dstu2.model.IdType(id);
            }
            case DSTU3: {
                return (IdType)new org.hl7.fhir.dstu3.model.IdType(id);
            }
            case R4: {
                return (IdType)new IdType(id);
            }
            case R4B: {
                return (IdType)new org.hl7.fhir.r4b.model.IdType(id);
            }
            case R5: {
                return (IdType)new org.hl7.fhir.r5.model.IdType(id);
            }
        }
        throw new IllegalArgumentException(String.format("newId does not support FHIR version %s", fhirVersionEnum.getFhirVersionString()));
    }
}

