/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.utility;

import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.dstu3.model.OperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.opencds.cqf.fhir.utility.FhirVersions;

public class OperationOutcomes {
    private OperationOutcomes() {
    }

    public static IBaseOperationOutcome newOperationOutcome(FhirVersionEnum fhirVersion) {
        switch (fhirVersion) {
            case DSTU3: {
                return new org.hl7.fhir.dstu3.model.OperationOutcome();
            }
            case R4: {
                return new org.hl7.fhir.r4.model.OperationOutcome();
            }
            case R5: {
                return new OperationOutcome();
            }
        }
        return null;
    }

    public static void addExceptionToOperationOutcome(IBaseOperationOutcome operationOutcome, String exceptionMessage) {
        FhirVersionEnum fhirVersion = FhirVersions.forClass(operationOutcome.getClass());
        switch (fhirVersion) {
            case DSTU3: {
                ((org.hl7.fhir.dstu3.model.OperationOutcome)operationOutcome).addIssue().setCode(OperationOutcome.IssueType.EXCEPTION).setSeverity(OperationOutcome.IssueSeverity.ERROR).setDiagnostics(exceptionMessage);
                break;
            }
            case R4: {
                ((org.hl7.fhir.r4.model.OperationOutcome)operationOutcome).addIssue().setCode(OperationOutcome.IssueType.EXCEPTION).setSeverity(OperationOutcome.IssueSeverity.ERROR).setDiagnostics(exceptionMessage);
                break;
            }
            case R5: {
                ((OperationOutcome)operationOutcome).addIssue().setCode(OperationOutcome.IssueType.EXCEPTION).setSeverity(OperationOutcome.IssueSeverity.ERROR).setDiagnostics(exceptionMessage);
            }
        }
    }
}

